/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.minecraft.view;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import sm0keysa1m0n.bliss.minecraft.fake.FakeLevel;
import sm0keysa1m0n.bliss.view.View;

public class EntityView
extends View {
    private final LivingEntity livingEntity;

    public EntityView(View.Properties properties, LivingEntity entity) {
        super(properties);
        this.livingEntity = entity;
    }

    public void renderContent(int mouseX, int mouseY) {
        super.renderContent(mouseX, mouseY);
        this.graphicsContext.exitManaged();
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.getEntityRenderDispatcher().prepare((Level)FakeLevel.getInstance(), minecraft.gameRenderer.getMainCamera(), null);
        float x = this.getScaledContentX() + this.getScaledContentWidth() / 2.0f;
        float y = this.getScaledContentY() + this.getScaledContentHeight();
        float eyeYOffset = 35.0f * this.getYScale() - this.getScaledContentHeight();
        float yaw = (float)Math.atan((x - (float)mouseX) / 40.0f);
        float pitch = (float)Math.atan((y + eyeYOffset - (float)mouseY) / this.getYScale() / 40.0f);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushPose();
        modelViewStack.translate((double)x, (double)y, 1050.0);
        modelViewStack.scale(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack poseStack = new PoseStack();
        poseStack.translate(0.0, 0.0, 1000.0);
        poseStack.scale(this.getXScale(), this.getYScale(), 1.0f);
        poseStack.scale(this.getContentWidth() / 2.0f, this.getContentHeight() / 2.0f, 1.0f);
        poseStack.mulPose(Vector3f.ZP.rotationDegrees(180.0f));
        float lastYBodyRot = this.livingEntity.yBodyRot;
        float lastYRot = this.livingEntity.getYRot();
        float lastXRot = this.livingEntity.getXRot();
        float lastYHeadRotO = this.livingEntity.yHeadRotO;
        float lastYHeadRot = this.livingEntity.yHeadRot;
        this.livingEntity.yBodyRot = 180.0f + yaw * 20.0f;
        this.livingEntity.setYRot(180.0f + yaw * 40.0f);
        this.livingEntity.setXRot(-pitch * 20.0f);
        this.livingEntity.yHeadRot = this.livingEntity.getYRot();
        this.livingEntity.yHeadRotO = this.livingEntity.getYRot();
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = minecraft.getEntityRenderDispatcher();
        entityRenderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        entityRenderDispatcher.render((Entity)this.livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.endBatch();
        entityRenderDispatcher.setRenderShadow(true);
        this.livingEntity.yBodyRot = lastYBodyRot;
        this.livingEntity.setYRot(lastYRot);
        this.livingEntity.setXRot(lastXRot);
        this.livingEntity.yHeadRotO = lastYHeadRotO;
        this.livingEntity.yHeadRot = lastYHeadRot;
        Lighting.setupFor3DItems();
        modelViewStack.popPose();
        RenderSystem.applyModelViewMatrix();
        this.graphicsContext.enterManaged();
    }
}

