/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.minecraft;

import io.github.humbleui.skija.Data;
import io.github.humbleui.skija.FontStyle;
import io.github.humbleui.skija.Image;
import io.github.humbleui.skija.svg.SVGDOM;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.StyledText;
import sm0keysa1m0n.bliss.TextDecoration;
import sm0keysa1m0n.bliss.TextVisitor;
import sm0keysa1m0n.bliss.view.ImageAccess;
import sm0keysa1m0n.bliss.view.SimpleImageAccess;
import sm0keysa1m0n.bliss.view.SvgImageAccess;

public class AdapterUtil {
    private static final Logger logger = LoggerFactory.getLogger(AdapterUtil.class);

    public static TextVisitor createTextVisitor(Component text) {
        return consumer -> text.visit((style, content) -> {
            consumer.accept(AdapterUtil.createStyledText(text), new TextDecoration(text.getStyle().isUnderlined(), text.getStyle().isStrikethrough()));
            return Optional.empty();
        }, Style.EMPTY);
    }

    public static StyledText createStyledText(Component component) {
        return new StyledText(component.getString(), AdapterUtil.createFontStyle(component.getStyle()), (Color)AdapterUtil.createColor(component.getStyle()).orElse(null));
    }

    public static Optional<Color> createColor(Style style) {
        return style.getColor() == null ? Optional.empty() : Optional.of(Color.create((int)(style.getColor().getValue() + -16777216)));
    }

    public static FontStyle createFontStyle(Style style) {
        return style.isBold() && style.isItalic() ? FontStyle.BOLD_ITALIC : (style.isBold() ? FontStyle.BOLD : (style.isItalic() ? FontStyle.ITALIC : FontStyle.NORMAL));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ImageAccess createImageAccess(ResourceLocation imageLocation) {
        try (InputStream inputStream = Minecraft.getInstance().getResourceManager().getResource(imageLocation).getInputStream();){
            byte[] bytes = inputStream.readAllBytes();
            if (imageLocation.getPath().endsWith(".svg")) {
                SvgImageAccess svgImageAccess = new SvgImageAccess(new SVGDOM(Data.makeFromBytes((byte[])bytes)));
                return svgImageAccess;
            }
            SimpleImageAccess simpleImageAccess = new SimpleImageAccess(Image.makeFromEncoded((byte[])bytes));
            return simpleImageAccess;
        }
        catch (IOException e) {
            logger.warn("Failed to load image: {}", (Object)imageLocation);
            return null;
        }
    }
}

