/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.minecraft.platform;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import sm0keysa1m0n.bliss.minecraft.platform.ResourceLocationParser;
import sm0keysa1m0n.bliss.platform.Platform;
import sm0keysa1m0n.bliss.style.parser.value.ValueParserRegistry;

public class MinecraftPlatform
implements Platform {
    private final Minecraft minecraft;

    public MinecraftPlatform(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public CompletableFuture<Void> submitToMainThread(Runnable task) {
        return this.minecraft.submit(task);
    }

    public <T> CompletableFuture<T> submitToMainThread(Supplier<T> task) {
        return this.minecraft.submit(task);
    }

    public boolean isMainThread() {
        return this.minecraft.isSameThread();
    }

    public Executor mainExecutor() {
        return this.minecraft;
    }

    public Executor backgroundExecutor() {
        return Util.backgroundExecutor();
    }

    public String getClipboard() {
        return this.minecraft.keyboardHandler.getClipboard();
    }

    public void setClipboard(String value) {
        this.minecraft.keyboardHandler.setClipboard(value);
    }

    public long milliTime() {
        return Util.getMillis();
    }

    public int ticksPerSecond() {
        return 20;
    }

    public boolean hasControlDown() {
        return Screen.hasControlDown();
    }

    public boolean hasShiftDown() {
        return Screen.hasShiftDown();
    }

    public boolean hasAltDown() {
        return Screen.hasAltDown();
    }

    static {
        ValueParserRegistry.instance().registerParser(ResourceLocation.class, ResourceLocationParser::parse);
    }
}

