/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.minecraft.platform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwjglNativeUtil {
    private static final Logger logger = LoggerFactory.getLogger(LwjglNativeUtil.class);
    private static Path nativesDir;

    private static void initNativesDir() {
        if (nativesDir != null) {
            return;
        }
        try {
            nativesDir = Files.createTempDirectory("natives", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Creating temp dir", e);
        }
        Object newLibPath = nativesDir.toString();
        logger.info("Adding library path: {}", newLibPath);
        String libPath = (String)Configuration.LIBRARY_PATH.get();
        if (libPath != null && !libPath.isEmpty()) {
            newLibPath = (String)newLibPath + File.pathSeparator + libPath;
        }
        System.setProperty(Configuration.LIBRARY_PATH.getProperty(), (String)newLibPath);
        Configuration.LIBRARY_PATH.set(newLibPath);
    }

    public static void load(String name) {
        String libName = Platform.mapLibraryNameBundled((String)name);
        try {
            Platform platform = Platform.get();
            Method mapLibraryNameMethod = Platform.class.getDeclaredMethod("mapLibraryName", String.class);
            mapLibraryNameMethod.setAccessible(true);
            libName = (String)mapLibraryNameMethod.invoke((Object)platform, libName);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        LwjglNativeUtil.initNativesDir();
        String resourcePath = "/lwjgl-natives/" + libName;
        URL resource = LwjglNativeUtil.class.getResource(resourcePath);
        if (resource == null) {
            throw new IllegalStateException("Resource not found: " + resourcePath);
        }
        try {
            LwjglNativeUtil.extract(nativesDir.resolve(libName), resource);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Extracting: " + libName, e);
        }
    }

    private static void extract(Path file, URL resource) throws IOException {
        InputStream source;
        if (Files.exists(file, new LinkOption[0])) {
            source = resource.openStream();
            try (InputStream target = Files.newInputStream(file, new OpenOption[0]);){
                if (LwjglNativeUtil.crc(source) == LwjglNativeUtil.crc(target)) {
                    logger.debug("Found at: {}", (Object)file);
                    return;
                }
            }
            finally {
                if (source != null) {
                    source.close();
                }
            }
        }
        logger.debug("Extracting: {}", (Object)resource.getPath());
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        source = resource.openStream();
        try {
            Files.copy(source, file, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (source != null) {
                source.close();
            }
        }
    }

    private static long crc(InputStream input) throws IOException {
        int n;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        while ((n = input.read(buffer)) != -1) {
            crc.update(buffer, 0, n);
        }
        return crc.getValue();
    }
}

