/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.minecraft;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class RenderUtil {
    public static final int FULL_LIGHT = 0xF000F0;

    public static void fillGradient(float x, float y, float x2, float y2, int startColor, int endColor) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder builder = tessellator.getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.vertex((double)x, (double)y2, 0.0).color(startRed, startGreen, startBlue, startAlpha).endVertex();
        builder.vertex((double)x2, (double)y2, 0.0).color(endRed, endGreen, endBlue, endAlpha).endVertex();
        builder.vertex((double)x2, (double)y, 0.0).color(endRed, endGreen, endBlue, endAlpha).endVertex();
        builder.vertex((double)x, (double)y, 0.0).color(startRed, startGreen, startBlue, startAlpha).endVertex();
        tessellator.end();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    public static void blitAvatar(ResourceLocation skin, float x, float y, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)skin);
        RenderUtil.spriteBlit(x, y, width, height, 8.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f);
    }

    public static void spriteBlit(float x, float y, float width, float height, float spriteX, float spriteY, float spriteWidth, float spriteHeight, float textureWidth, float textureHeight) {
        RenderUtil.spriteBlit(x, y, x + width, y + height, 0.0f, spriteWidth, spriteHeight, spriteX, spriteY, textureWidth, textureHeight);
    }

    public static void spriteBlit(float x, float y, float x2, float y2, float z, float spriteWidth, float spriteHeight, float spriteX, float spriteY, float textureWidth, float textureHeight) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderUtil.blit(x, y, x2, y2, spriteX / textureWidth, (spriteY + spriteHeight) / textureHeight, (spriteX + spriteWidth) / textureWidth, spriteY / textureHeight);
    }

    public static void blit(float x, float y, float x2, float y2, float u, float v, float u2, float v2) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.vertex((double)x, (double)y2, 0.0).uv(u, v).endVertex();
        builder.vertex((double)x2, (double)y2, 0.0).uv(u2, v).endVertex();
        builder.vertex((double)x2, (double)y, 0.0).uv(u2, v2).endVertex();
        builder.vertex((double)x, (double)y, 0.0).uv(u, v2).endVertex();
        tesselator.end();
    }
}

