/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.minecraft.platform;

import com.google.common.collect.HashMultimap;
import io.github.humbleui.skija.Data;
import io.github.humbleui.skija.Typeface;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import sm0keysa1m0n.bliss.style.StyleList;
import sm0keysa1m0n.bliss.style.parser.StyleSheetParser;

public class StyleSheetManager
extends SimplePreparableReloadListener<Map<ResourceLocation, StyleList>> {
    private static final ResourceLocation USER_AGENT = new ResourceLocation("bliss", "user-agent");
    private static StyleSheetManager instance;
    private Map<ResourceLocation, StyleList> styleLists = Collections.emptyMap();

    public StyleList createStyleList(Iterable<ResourceLocation> styleSheets) {
        StyleList userAgentList = this.styleLists.get(USER_AGENT);
        StyleList list = userAgentList == null ? new StyleList() : new StyleList(userAgentList);
        for (ResourceLocation name : styleSheets) {
            StyleList styleSheet = this.styleLists.get(name);
            if (styleSheet == null) {
                throw new IllegalArgumentException("Unknown style sheet: " + name);
            }
            list.merge(styleSheet);
        }
        return list;
    }

    protected Map<ResourceLocation, StyleList> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Collection resources = resourceManager.listResources("css", resource -> resource.endsWith(".css"));
        HashMap<ResourceLocation, StyleList> styleLists = new HashMap<ResourceLocation, StyleList>();
        HashMultimap pendingMerge = HashMultimap.create();
        for (ResourceLocation resource2 : resources) {
            String path = resource2.getPath();
            ResourceLocation name = new ResourceLocation(resource2.getNamespace(), path.substring("css/".length(), path.length() - ".css".length()));
            try {
                InputStream inputStream = resourceManager.getResource(resource2).getInputStream();
                try {
                    StyleSheetParser.ParseResult result = StyleSheetParser.loadStyleSheet((InputStream)inputStream, fontLocation -> StyleSheetManager.loadFont(resourceManager, new ResourceLocation(fontLocation)));
                    styleLists.put(name, result.styleList());
                    pendingMerge.putAll((Object)result.styleList(), result.dependencies().stream().map(ResourceLocation::new).toList());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }
        pendingMerge.forEach((styleList, dependencyLocation) -> {
            StyleList dependency = (StyleList)styleLists.get(dependencyLocation);
            if (dependency == null) {
                throw new IllegalStateException("Style sheet not found: " + dependencyLocation.toString());
            }
            styleList.merge(dependency);
        });
        return styleLists;
    }

    protected void apply(Map<ResourceLocation, StyleList> styleLists, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.styleLists = styleLists;
    }

    private static Typeface loadFont(ResourceManager resourceManager, ResourceLocation location) throws IOException {
        try (InputStream inputStream = resourceManager.getResource(location).getInputStream();){
            Typeface typeface = Typeface.makeFromData((Data)Data.makeFromBytes((byte[])inputStream.readAllBytes()));
            return typeface;
        }
    }

    public static StyleSheetManager getInstance() {
        if (instance == null) {
            instance = new StyleSheetManager();
        }
        return instance;
    }
}

