/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.minecraft.fake;

import com.google.common.base.MoreObjects;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import sm0keysa1m0n.bliss.minecraft.fake.FakeLevel;

public class FakePlayer
extends AbstractClientPlayer {
    private final Map<MinecraftProfileTexture.Type, ResourceLocation> textureLocations = new EnumMap<MinecraftProfileTexture.Type, ResourceLocation>(MinecraftProfileTexture.Type.class);
    private boolean pendingTextures;
    private String skinModel;

    public FakePlayer(GameProfile gameProfile) {
        super((ClientLevel)FakeLevel.getInstance(), gameProfile);
    }

    public String getModelName() {
        return this.skinModel == null ? DefaultPlayerSkin.getSkinModelName((UUID)this.getGameProfile().getId()) : this.skinModel;
    }

    public boolean isSkinLoaded() {
        return this.textureLocations.containsKey(MinecraftProfileTexture.Type.SKIN);
    }

    public ResourceLocation getSkinTextureLocation() {
        this.registerTextures();
        return (ResourceLocation)MoreObjects.firstNonNull((Object)this.textureLocations.get(MinecraftProfileTexture.Type.SKIN), (Object)DefaultPlayerSkin.getDefaultSkin((UUID)this.getGameProfile().getId()));
    }

    public boolean isCapeLoaded() {
        return this.textureLocations.containsKey(MinecraftProfileTexture.Type.CAPE);
    }

    public ResourceLocation getCloakTextureLocation() {
        this.registerTextures();
        return this.textureLocations.get(MinecraftProfileTexture.Type.CAPE);
    }

    public boolean isElytraLoaded() {
        return this.textureLocations.containsKey(MinecraftProfileTexture.Type.ELYTRA);
    }

    public ResourceLocation getElytraTextureLocation() {
        this.registerTextures();
        return this.textureLocations.get(MinecraftProfileTexture.Type.ELYTRA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTextures() {
        FakePlayer fakePlayer = this;
        synchronized (fakePlayer) {
            if (!this.pendingTextures) {
                this.pendingTextures = true;
                Minecraft.getInstance().getSkinManager().registerSkins(this.getGameProfile(), (type, textureLocation, texture) -> {
                    this.textureLocations.put(type, textureLocation);
                    if (type == MinecraftProfileTexture.Type.SKIN) {
                        this.skinModel = texture.getMetadata("model");
                        if (this.skinModel == null) {
                            this.skinModel = "default";
                        }
                    }
                }, true);
            }
        }
    }

    public Vec3 position() {
        return new Vec3(99.0, 99.0, 99.0);
    }

    protected PlayerInfo getPlayerInfo() {
        return null;
    }

    public boolean isSpectator() {
        return false;
    }

    public boolean isInvisibleTo(Player playerEntity) {
        return false;
    }

    public Team getTeam() {
        return null;
    }
}

