/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.util;

public class MathUtil {
    public static int ceil(float value) {
        int i = (int)value;
        return value > (float)i ? i + 1 : i;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static int multiplyAlpha(int color, float alpha) {
        int newAlpha = (int)((float)(color >> 24 & 0xFF) * alpha);
        int rgb = color & 0xFFFFFF;
        return newAlpha << 24 | rgb;
    }

    public static float[] getColor4f(int[] colour4i) {
        return new float[]{(float)colour4i[0] / 255.0f, (float)colour4i[1] / 255.0f, (float)colour4i[2] / 255.0f, (float)colour4i[3] / 255.0f};
    }

    public static int[] getColor4i(int color) {
        int[] rgba = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color >> 0 & 0xFF, color >> 24 & 0xFF};
        return rgba;
    }

    public static int[] getColor4i(float[] color4f) {
        return new int[]{(int)(color4f[0] * 255.0f), (int)(color4f[1] * 255.0f), (int)(color4f[2] * 255.0f), (int)(color4f[3] * 255.0f)};
    }

    public static int getColorHex(int[] color4i) {
        return (color4i[3] & 0xFF) << 24 | (color4i[0] & 0xFF) << 16 | (color4i[1] & 0xFF) << 8 | (color4i[2] & 0xFF) << 0;
    }

    public static float lerp(float percent, float start, float end) {
        return start + percent * (end - start);
    }

    public static long lerp(float percent, int colour1, int colour2) {
        return MathUtil.getColorHex(MathUtil.lerp(percent, MathUtil.getColor4i(colour1), MathUtil.getColor4i(colour2)));
    }

    public static int[] lerp(float percent, int[] colour1, int[] colour2) {
        int[] rgba = new int[4];
        for (int i = 0; i < 4; ++i) {
            rgba[i] = (int)MathUtil.lerp(percent, colour1[i], colour2[i]);
        }
        return rgba;
    }

    public static float[] lerp(float percent, float[] colour1, float[] colour2) {
        float[] rgba = new float[4];
        for (int i = 0; i < 4; ++i) {
            rgba[i] = MathUtil.lerp(percent, colour1[i], colour2[i]);
        }
        return rgba;
    }
}

