/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.selector;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.style.States;
import sm0keysa1m0n.bliss.style.StyleNode;
import sm0keysa1m0n.bliss.style.selector.Selector;
import sm0keysa1m0n.bliss.style.selector.StyleNodeState;

public record SingleSelector(String id, int specificity, Function<StyleNode, Optional<Set<StyleNodeState>>> matcher) implements Selector
{
    public static final int WILDCARD_SPECIFICITY = 0;
    public static final int TYPE_SPECIFICITY = 1;
    public static final int CLASS_SPECIFICITY = 1000;
    public static final int ID_SPECIFICITY = 1000000;
    public static final int PSEUDOCLASS_SPECIFICITY = 1000;
    public static final int STRUCTURAL_PSEUDOCLASS_SPECIFICITY = 1000;
    public static final SingleSelector WILDCARD = SingleSelector.predicate("*", 0, (Predicate<StyleNode>)Predicates.alwaysTrue());
    public static final SingleSelector FIRST_CHILD = SingleSelector.structural(":first-child", style -> style.getIndex() == 0);
    public static final SingleSelector LAST_CHILD = SingleSelector.structural(":last-child", style -> {
        StyleNode parent = style.getParent();
        if (parent == null) {
            return false;
        }
        int childCount = parent.getChildStyles().size();
        return childCount == 1 || style.getIndex() == childCount - 1;
    });
    public static final SingleSelector ONLY_CHILD = SingleSelector.structural(":only-child", style -> style.getParent().getChildStyles().size() == 1);
    public static final SingleSelector FIRST_OF_TYPE = SingleSelector.structural(":first-of-type", style -> {
        StyleNode parent = style.getParent();
        if (parent == null) {
            return false;
        }
        List<? extends StyleNode> childStyles = parent.getChildStyles();
        if (childStyles.size() == 1) {
            return true;
        }
        for (StyleNode styleNode : childStyles) {
            if (styleNode == style) {
                return true;
            }
            if (!styleNode.getType().equals(style.getType())) continue;
            return false;
        }
        return false;
    });
    public static final SingleSelector LAST_OF_TYPE = SingleSelector.structural(":last-of-type", style -> {
        StyleNode parent = style.getParent();
        if (parent == null) {
            return false;
        }
        List<? extends StyleNode> childStyles = parent.getChildStyles();
        if (childStyles.size() == 1) {
            return true;
        }
        for (int i = childStyles.size() - 1; i >= 0; --i) {
            StyleNode childStyle = childStyles.get(i);
            if (childStyle == style) {
                return true;
            }
            if (!childStyle.getType().equals(style.getType())) continue;
            return false;
        }
        return false;
    });
    public static final SingleSelector ONLY_OF_TYPE = SingleSelector.structural(":only-of-type", style -> {
        StyleNode parent = style.getParent();
        if (parent == null) {
            return false;
        }
        List<? extends StyleNode> childStyles = parent.getChildStyles();
        if (childStyles.size() == 1) {
            return true;
        }
        for (StyleNode styleNode : childStyles) {
            if (!styleNode.getType().equals(style.getType()) || styleNode == style) continue;
            return false;
        }
        return true;
    });

    private static SingleSelector structural(String id, Predicate<StyleNode> predicate) {
        return SingleSelector.predicate(id, 1000, predicate);
    }

    private static SingleSelector predicate(String id, int specificity, Predicate<StyleNode> predicate) {
        return new SingleSelector(id, specificity, node -> predicate.test((StyleNode)node) ? Optional.of(Set.of()) : Optional.empty());
    }

    @Override
    public Optional<Set<StyleNodeState>> match(StyleNode node) {
        return this.matcher.apply(node);
    }

    @Override
    public int getSpecificity() {
        return this.specificity;
    }

    @Override
    public String toString() {
        return "Selector[" + this.id + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SingleSelector)) return false;
        SingleSelector that = (SingleSelector)o;
        if (!that.id.equals(this.id)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    public static SingleSelector ofType(String type) {
        return SingleSelector.predicate(type, 1, node -> type.equals(node.getType()));
    }

    public static SingleSelector ofClass(String styleClass) {
        return SingleSelector.predicate("." + styleClass, 1000, node -> node.getStyleClasses().contains(styleClass));
    }

    public static SingleSelector ofId(String id) {
        return SingleSelector.predicate("#" + id, 1000000, node -> id.equals(node.getId()));
    }

    public static SingleSelector ofState(String pseudoClass) {
        int state = States.get(pseudoClass).orElseThrow(() -> new IllegalStateException("Invalid pseudo class: " + pseudoClass));
        return new SingleSelector(":" + pseudoClass, 1000, node -> Optional.of(Set.of(new StyleNodeState((StyleNode)node, state))));
    }

    @Nullable
    public static SingleSelector parseStructural(String selector, Function<String, Selector[]> selectorListParser) {
        return switch (selector) {
            case "first-child" -> FIRST_CHILD;
            case "last-child" -> LAST_CHILD;
            case "only-child" -> ONLY_CHILD;
            case "first-of-type" -> FIRST_OF_TYPE;
            case "last-of-type" -> LAST_OF_TYPE;
            case "only-of-type" -> ONLY_OF_TYPE;
            default -> {
                String nthChild = "nth-child(";
                if (selector.startsWith(nthChild)) {
                    int n = Integer.parseInt(selector.substring(nthChild.length(), selector.lastIndexOf(41)));
                    yield SingleSelector.structural(":nth-child(" + n + ")", style -> style.getIndex() == n - 1);
                }
                yield null;
            }
        };
    }
}

