/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.parser.value;

import io.github.humbleui.skija.paragraph.Alignment;
import io.github.humbleui.skija.paragraph.Shadow;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jdesktop.core.animation.timing.Interpolator;
import sm0keysa1m0n.bliss.BoxShadow;
import sm0keysa1m0n.bliss.BoxSizing;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.Display;
import sm0keysa1m0n.bliss.Filter;
import sm0keysa1m0n.bliss.ImageRendering;
import sm0keysa1m0n.bliss.Length;
import sm0keysa1m0n.bliss.ObjectFit;
import sm0keysa1m0n.bliss.Overflow;
import sm0keysa1m0n.bliss.PointerEvents;
import sm0keysa1m0n.bliss.Visibility;
import sm0keysa1m0n.bliss.layout.Align;
import sm0keysa1m0n.bliss.layout.FlexDirection;
import sm0keysa1m0n.bliss.layout.Justify;
import sm0keysa1m0n.bliss.layout.PositionType;
import sm0keysa1m0n.bliss.layout.Wrap;
import sm0keysa1m0n.bliss.style.Percentage;
import sm0keysa1m0n.bliss.style.parser.StyleReader;
import sm0keysa1m0n.bliss.style.parser.value.ArrayParser;
import sm0keysa1m0n.bliss.style.parser.value.BoxShadowParser;
import sm0keysa1m0n.bliss.style.parser.value.ColorParser;
import sm0keysa1m0n.bliss.style.parser.value.EnumParser;
import sm0keysa1m0n.bliss.style.parser.value.FilterParser;
import sm0keysa1m0n.bliss.style.parser.value.InterpolatorParser;
import sm0keysa1m0n.bliss.style.parser.value.LengthParser;
import sm0keysa1m0n.bliss.style.parser.value.PercentageParser;
import sm0keysa1m0n.bliss.style.parser.value.ShadowParser;
import sm0keysa1m0n.bliss.style.parser.value.ValueParser;

public final class ValueParserRegistry {
    private static ValueParserRegistry instance;
    private final Map<Class<?>, ValueParser<?>> styleParsers = new IdentityHashMap();

    public static ValueParserRegistry instance() {
        if (instance == null) {
            instance = new ValueParserRegistry();
        }
        return instance;
    }

    private ValueParserRegistry() {
        this.registerBuiltins();
    }

    public <T> void registerParser(Class<T> valueClass, ValueParser<T> parser) {
        this.styleParsers.put(valueClass, parser);
    }

    public <T> ValueParser<T> getParser(Class<T> valueClass) {
        ValueParser<?> parser = this.styleParsers.get(valueClass);
        if (parser == null) {
            throw new IllegalStateException("No parser registered for: " + valueClass.getSimpleName());
        }
        return parser;
    }

    private void registerBuiltins() {
        this.registerParser(String[].class, new ArrayParser<String>(String.class, StyleReader::readString, ','));
        this.registerParser(Shadow[].class, new ArrayParser<Shadow>(Shadow.class, ShadowParser::parse, ','));
        this.registerParser(Filter[].class, new ArrayParser<Filter>(Filter.class, FilterParser::parse, ' '));
        this.registerParser(BoxShadow[].class, new ArrayParser<BoxShadow>(BoxShadow.class, BoxShadowParser::parse, ','));
        this.registerParser(String.class, StyleReader::readString);
        this.registerParser(Boolean.class, StyleReader::readBoolean);
        this.registerParser(Integer.class, StyleReader::readInteger);
        this.registerParser(Long.class, StyleReader::readLong);
        this.registerParser(Float.class, StyleReader::readFloat);
        this.registerParser(Double.class, StyleReader::readDouble);
        this.registerParser(Percentage.class, PercentageParser::parse);
        this.registerParser(Length.class, LengthParser::parse);
        this.registerParser(Color.class, ColorParser::parse);
        this.registerParser(Interpolator.class, InterpolatorParser::parse);
        this.registerParser(Align.class, new EnumParser<Align>(Align.class));
        this.registerParser(FlexDirection.class, new EnumParser<FlexDirection>(FlexDirection.class));
        this.registerParser(Justify.class, new EnumParser<Justify>(Justify.class));
        this.registerParser(PositionType.class, new EnumParser<PositionType>(PositionType.class));
        this.registerParser(Display.class, new EnumParser<Display>(Display.class));
        this.registerParser(Overflow.class, new EnumParser<Overflow>(Overflow.class));
        this.registerParser(ObjectFit.class, new EnumParser<ObjectFit>(ObjectFit.class));
        this.registerParser(Wrap.class, new EnumParser<Wrap>(Wrap.class));
        this.registerParser(Alignment.class, new EnumParser<Alignment>(Alignment.class));
        this.registerParser(Visibility.class, new EnumParser<Visibility>(Visibility.class));
        this.registerParser(BoxSizing.class, new EnumParser<BoxSizing>(BoxSizing.class));
        this.registerParser(PointerEvents.class, new EnumParser<PointerEvents>(PointerEvents.class));
        this.registerParser(ImageRendering.class, new EnumParser<ImageRendering>(ImageRendering.class));
    }
}

