/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss;

import it.unimi.dsi.fastutil.floats.FloatConsumer;
import sm0keysa1m0n.bliss.calc.CalcExpressionNode;

public interface Length {
    public static final Length ZERO = new Fixed(0.0f);
    public static final Length AUTO = new Length(){

        @Override
        public void dispatch(FloatConsumer fixed, FloatConsumer percentage, Runnable auto) {
            auto.run();
        }

        @Override
        public float valueForLength(float maximumValue) {
            return maximumValue;
        }

        @Override
        public Type type() {
            return Type.AUTO;
        }

        public String toString() {
            return "Length[auto]";
        }
    };
    public static final Length UNDEFINED = new Length(){

        @Override
        public void dispatch(FloatConsumer fixed, FloatConsumer percentage, Runnable auto) {
            throw new IllegalStateException("Undefined.");
        }

        @Override
        public float valueForLength(float maximumValue) {
            throw new IllegalStateException("Undefined.");
        }

        @Override
        public Type type() {
            return Type.UNDEFINED;
        }

        public String toString() {
            return "Length[undefined]";
        }
    };

    default public void dispatch(FloatConsumer fixed, FloatConsumer percentage) {
        this.dispatch(fixed, percentage, () -> {
            throw new IllegalStateException("Auto not supported.");
        });
    }

    public void dispatch(FloatConsumer var1, FloatConsumer var2, Runnable var3);

    default public float percent() {
        throw new IllegalStateException("Not a percentage.");
    }

    default public float fixed() {
        throw new IllegalStateException("Not a fixed value.");
    }

    public float valueForLength(float var1);

    public Type type();

    public static Length fixed(float value) {
        return new Fixed(value);
    }

    public static Length percentage(float value) {
        return new Percentage(value);
    }

    public static Length calculated(CalcExpressionNode root) {
        return new Calculated(root);
    }

    public record Fixed(float value) implements Length
    {
        @Override
        public void dispatch(FloatConsumer fixed, FloatConsumer percentage, Runnable auto) {
            fixed.accept(this.value);
        }

        @Override
        public float valueForLength(float maximumValue) {
            return this.value;
        }

        @Override
        public float fixed() {
            return this.value;
        }

        @Override
        public Type type() {
            return Type.FIXED;
        }
    }

    public record Percentage(float value) implements Length
    {
        @Override
        public void dispatch(FloatConsumer fixed, FloatConsumer percentage, Runnable auto) {
            percentage.accept(this.value);
        }

        @Override
        public float percent() {
            return this.value;
        }

        @Override
        public float valueForLength(float maximumValue) {
            return maximumValue * this.value / 100.0f;
        }

        @Override
        public Type type() {
            return Type.PERCENTAGE;
        }
    }

    public record Calculated(CalcExpressionNode root) implements Length
    {
        @Override
        public void dispatch(FloatConsumer fixed, FloatConsumer percentage, Runnable auto) {
            throw new IllegalStateException("Undefined.");
        }

        @Override
        public float valueForLength(float maximumValue) {
            return this.root.evaluate(maximumValue);
        }

        @Override
        public Type type() {
            return Type.CALCULATED;
        }
    }

    public static enum Type {
        FIXED,
        PERCENTAGE,
        AUTO,
        CALCULATED,
        UNDEFINED;

    }

    public static enum ValueRange {
        ALL,
        NON_NEGATIVE;

    }
}

