/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import io.github.humbleui.skija.Canvas;
import io.github.humbleui.skija.FontMgr;
import io.github.humbleui.skija.Paint;
import io.github.humbleui.skija.Picture;
import io.github.humbleui.skija.PictureRecorder;
import io.github.humbleui.skija.paragraph.Alignment;
import io.github.humbleui.skija.paragraph.DecorationStyle;
import io.github.humbleui.skija.paragraph.FontCollection;
import io.github.humbleui.skija.paragraph.Paragraph;
import io.github.humbleui.skija.paragraph.ParagraphBuilder;
import io.github.humbleui.skija.paragraph.ParagraphStyle;
import io.github.humbleui.skija.paragraph.Shadow;
import io.github.humbleui.skija.paragraph.TextStyle;
import io.github.humbleui.types.Rect;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.Size;
import sm0keysa1m0n.bliss.StyledText;
import sm0keysa1m0n.bliss.TextDecoration;
import sm0keysa1m0n.bliss.TextVisitor;
import sm0keysa1m0n.bliss.layout.Layout;
import sm0keysa1m0n.bliss.layout.MeasureMode;
import sm0keysa1m0n.bliss.util.MathUtil;
import sm0keysa1m0n.bliss.view.View;

public class TextView
extends View {
    private TextVisitor text = __ -> {};
    private boolean wrap = true;
    @Nullable
    private Paragraph paragraph = null;
    private int textCount;
    private FontMgr fontManager = FontMgr.getDefault();

    public TextView(View.Properties properties) {
        super(properties);
        this.getStyle().color.addListener(color -> {
            if (this.paragraph != null && this.isAdded()) {
                this.paragraph.updateForegroundPaint(0, this.textCount, new Paint().setColor(color.hex()));
                this.paragraph.layout(this.getContentWidth() * this.graphicsContext.scale());
            }
        });
        this.getStyle().fontFamily.addListener(__ -> this.buildParagraph());
        this.getStyle().fontSize.addListener(fontSize -> {
            if (this.paragraph != null && this.isAdded()) {
                this.paragraph.updateFontSize(0, this.textCount, (float)fontSize.intValue());
                this.paragraph.layout(this.getContentWidth() * this.graphicsContext.scale());
            }
        });
        this.getStyle().textAlign.addListener(textAlign -> {
            if (this.paragraph != null && this.isAdded()) {
                this.paragraph.updateAlignment(textAlign);
                this.paragraph.layout(this.getContentWidth() * this.graphicsContext.scale());
            }
        });
        this.getStyle().textShadow.addListener(__ -> this.buildParagraph());
    }

    @Override
    public void styleRefreshed(FontMgr fontManager) {
        if (this.fontManager != FontMgr.getDefault()) {
            this.fontManager.close();
        }
        this.fontManager = fontManager;
        this.buildParagraph();
    }

    @Override
    protected void setLayout(Layout layout) {
        super.setLayout(layout);
        layout.setMeasureFunction(this::measure);
    }

    public TextView setWrap(boolean wrap) {
        this.wrap = wrap;
        if (this.isAdded()) {
            this.getLayout().markDirty();
            this.parent.layout();
        }
        return this;
    }

    public TextView setText(@Nullable String text) {
        return this.setText(StyledText.of(text));
    }

    public TextView setText(StyledText text) {
        return this.setText(text, TextDecoration.NONE);
    }

    public TextView setText(StyledText text, TextDecoration decoration) {
        return this.setText((BiConsumer<StyledText, TextDecoration> consumer) -> consumer.accept(text, decoration));
    }

    public TextView setText(TextVisitor text) {
        this.text = text;
        this.buildParagraph();
        if (this.isAdded()) {
            this.getLayout().markDirty();
            this.parent.layout();
        }
        return this;
    }

    private void buildParagraph() {
        if (this.paragraph != null) {
            this.paragraph.close();
            this.paragraph = null;
        }
        this.textCount = 0;
        try (ParagraphStyle paragraphStyle = new ParagraphStyle().setAlignment((Alignment)this.getStyle().textAlign.get()).setEllipsis("...").setMaxLinesCount(this.wrap ? Integer.MAX_VALUE : 1L);
             FontCollection fontCollection = new FontCollection().setDefaultFontManager(this.fontManager).setDynamicFontManager(FontMgr.getDefault());
             ParagraphBuilder builder = new ParagraphBuilder(paragraphStyle, fontCollection);){
            this.text.visit((styledText, decoration) -> {
                int color = styledText.color() == null ? ((Color)this.getStyle().color.get()).hex() : styledText.color().hex();
                try (TextStyle textStyle = new TextStyle().setFontSize((float)((Integer)this.getStyle().fontSize.get()).intValue() * this.graphicsContext.scale()).setFontFamilies((String[])this.getStyle().fontFamily.get()).addShadows((Shadow[])this.getStyle().textShadow.get()).setColor(color).setFontStyle(styledText.fontStyle()).setDecorationStyle(DecorationStyle.NONE.withUnderline(decoration.underline()).withLineThrough(decoration.lineThrough()).withColor(color));){
                    builder.pushStyle(textStyle);
                    builder.addText(styledText.text());
                    this.textCount += styledText.text().length();
                    builder.popStyle();
                }
            });
            this.paragraph = builder.build();
        }
    }

    @Override
    public void layout() {
        if (this.paragraph != null) {
            this.paragraph.updateFontSize(0, this.textCount, (float)((Integer)this.getStyle().fontSize.get()).intValue() * this.graphicsContext.scale());
            this.paragraph.layout(this.getContentWidth() * this.graphicsContext.scale());
        }
        super.layout();
    }

    private Size measure(MeasureMode widthMode, float width, MeasureMode heightMode, float height) {
        this.paragraph.updateFontSize(0, this.textCount, (float)((Integer)this.getStyle().fontSize.get()).intValue() * this.graphicsContext.scale());
        switch (widthMode) {
            case UNDEFINED: 
            case AT_MOST: {
                this.paragraph.layout(widthMode == MeasureMode.UNDEFINED ? Float.MAX_VALUE : (float)MathUtil.ceil(width) * this.graphicsContext.scale());
                width = this.paragraph.getMaxIntrinsicWidth() / this.graphicsContext.scale();
                break;
            }
            default: {
                this.paragraph.layout((float)MathUtil.ceil(width) * this.graphicsContext.scale());
            }
        }
        return new Size(width, this.paragraph.getHeight() / this.graphicsContext.scale());
    }

    @Override
    public float computeFullHeight() {
        return this.paragraph == null ? super.computeFullHeight() : this.paragraph.getHeight() / this.graphicsContext.scale();
    }

    @Override
    public void renderContent(int mouseX, int mouseY) {
        super.renderContent(mouseX, mouseY);
        if (this.paragraph != null) {
            Canvas canvas = this.graphicsContext.canvas();
            canvas.translate(this.getScaledContentX() * this.graphicsContext.scale(), this.getScaledContentY() * this.graphicsContext.scale());
            canvas.scale(this.getXScale(), this.getYScale());
            try (PictureRecorder recorder = new PictureRecorder();){
                Canvas recordingCanvas = recorder.beginRecording(Rect.makeWH((float)this.paragraph.getMaxWidth(), (float)this.paragraph.getHeight()));
                this.paragraph.paint(recordingCanvas, 0.0f, 0.0f);
                Picture picture = recorder.finishRecordingAsPicture();
                try (Paint paint = new Paint().setAlphaf(this.getAlpha());){
                    canvas.drawPicture(picture, null, paint);
                }
            }
            canvas.resetMatrix();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.paragraph != null) {
            this.paragraph.close();
            this.paragraph = null;
        }
        if (this.fontManager != FontMgr.getDefault()) {
            this.fontManager.close();
        }
    }
}

