/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import io.github.humbleui.skija.Canvas;
import io.github.humbleui.skija.Font;
import io.github.humbleui.skija.FontMgr;
import io.github.humbleui.skija.FontStyle;
import io.github.humbleui.skija.FontStyleSet;
import io.github.humbleui.skija.Paint;
import io.github.humbleui.skija.PaintMode;
import io.github.humbleui.skija.TextBlob;
import io.github.humbleui.skija.TextLine;
import io.github.humbleui.skija.Typeface;
import io.github.humbleui.skija.impl.Native;
import io.github.humbleui.skija.impl.Stats;
import io.github.humbleui.skija.shaper.Shaper;
import io.github.humbleui.types.Rect;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Bliss;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.platform.Cursor;
import sm0keysa1m0n.bliss.util.MathUtil;
import sm0keysa1m0n.bliss.view.View;

public class TextFieldView
extends View {
    private static final int CARET_WIDTH = 1;
    private FontMgr fontManager = FontMgr.getDefault();
    @Nullable
    private Typeface typeface;
    private String text = "";
    private Font font;
    private TextLine textLine;
    private int selectionOffset;
    private int caretIndex;
    private int caretBlinkTicks;
    private float xOffset = 1.0f;
    private int maxLength;
    @Nullable
    private Consumer<String> responder;
    @Nullable
    private String placeholder;

    public TextFieldView(View.Properties properties) {
        super(properties.focusable(true));
    }

    public String getText() {
        return this.text;
    }

    public TextFieldView setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (maxLength != 0 && this.text.length() > maxLength) {
            this.setText(this.text);
        }
        return this;
    }

    public TextFieldView setResponder(@Nullable Consumer<String> responder) {
        this.responder = responder;
        return this;
    }

    public TextFieldView setPlaceholder(@Nullable String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @Override
    public void styleRefreshed(FontMgr fontManager) {
        if (this.fontManager != FontMgr.getDefault()) {
            this.fontManager.close();
        }
        this.fontManager = fontManager;
        this.typeface = null;
        for (String family : (String[])this.getStyle().fontFamily.get()) {
            FontStyleSet fontSet = this.fontManager.matchFamily(family);
            if (fontSet.count() <= 0) continue;
            this.typeface = fontSet.matchStyle(FontStyle.NORMAL);
            break;
        }
        this.refreshTextLine();
    }

    @Override
    public void close() {
        super.close();
        this.textLine.close();
        this.font.close();
        if (this.typeface != null) {
            this.typeface.close();
        }
        if (this.fontManager != FontMgr.getDefault()) {
            this.fontManager.close();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.caretBlinkTicks++ >= Bliss.instance().platform().ticksPerSecond()) {
            this.caretBlinkTicks = 0;
        }
    }

    @Override
    public Optional<View> changeFocus(boolean forward) {
        Optional<View> result = super.changeFocus(forward);
        if (result.isPresent()) {
            this.selectAll();
        }
        return result;
    }

    @Override
    protected void renderContent(int mouseX, int mouseY) {
        super.renderContent(mouseX, mouseY);
        Canvas canvas = this.graphicsContext.canvas();
        float scale = this.graphicsContext.scale();
        canvas.save();
        canvas.clipRect(Rect.makeXYWH((float)(this.getScaledContentX() * scale), (float)(this.getScaledContentY() * scale), (float)(this.getScaledContentWidth() * scale), (float)(this.getScaledContentHeight() * scale)));
        int textColor = ((Color)this.getStyle().color.get()).multiplied(this.getAlpha());
        canvas.translate(this.getScaledContentX() * scale + this.xOffset, 0.0f);
        this.drawCaretOrSelection(canvas, textColor);
        canvas.translate(0.0f, this.getScaledContentY() * scale + this.textLine.getHeight() + this.getScaledContentHeight() * scale / 2.0f - this.textLine.getXHeight() * 2.0f);
        if (this.text.length() > 0) {
            try (Paint paint = new Paint();){
                TextBlob blob;
                int endIndex;
                paint.setColor(textColor);
                if (this.selectionOffset == 0) {
                    canvas.drawTextLine(this.textLine, 0.0f, 0.0f, paint);
                }
                short[] glyphs = this.textLine.getGlyphs();
                float[] positions = this.textLine.getPositions();
                int startIndex = Math.min(this.caretIndex, this.getOffsetCaretIndex());
                if (startIndex != 0) {
                    short[] headGlyphs = Arrays.copyOfRange(glyphs, 0, startIndex);
                    float[] headPositions = Arrays.copyOfRange(positions, 0, startIndex * 2);
                    try (TextBlob blob2 = TextFieldView.makeBlobFromPos(headGlyphs, headPositions, this.font);){
                        canvas.drawTextBlob(blob2, 0.0f, 0.0f, paint);
                    }
                }
                if ((endIndex = Math.max(this.caretIndex, this.getOffsetCaretIndex())) != this.text.length()) {
                    short[] tailGlyphs = Arrays.copyOfRange(glyphs, endIndex, glyphs.length);
                    float[] tailPositions = Arrays.copyOfRange(positions, endIndex * 2, positions.length * 2);
                    blob = TextFieldView.makeBlobFromPos(tailGlyphs, tailPositions, this.font);
                    try {
                        canvas.drawTextBlob(blob, 0.0f, 0.0f, paint);
                    }
                    finally {
                        if (blob != null) {
                            blob.close();
                        }
                    }
                }
                short[] selectedGlyphs = Arrays.copyOfRange(glyphs, startIndex, endIndex);
                float[] selectedPositions = Arrays.copyOfRange(positions, startIndex * 2, endIndex * 2);
                blob = TextFieldView.makeBlobFromPos(selectedGlyphs, selectedPositions, this.font);
                try (Paint selectedPaint = new Paint();){
                    selectedPaint.setColor(0xFFFFFF).setAlphaf(this.getAlpha());
                    canvas.drawTextBlob(blob, 0.0f, 0.0f, selectedPaint);
                }
                finally {
                    if (blob != null) {
                        blob.close();
                    }
                }
            }
        } else if (this.placeholder != null) {
            try (Paint paint = new Paint();){
                paint.setColor(0x808080).setAlphaf(this.getAlpha());
                canvas.drawString(this.placeholder, 0.0f, 0.0f, this.font, paint);
            }
        }
        canvas.restore();
    }

    private void drawCaretOrSelection(Canvas canvas, int textColor) {
        if (!this.isFocused()) {
            return;
        }
        short[] glyphs = this.textLine.getGlyphs();
        float scale = this.graphicsContext.scale();
        float caretX = 0.0f;
        float lineHeight = this.textLine.getHeight() - this.textLine.getXHeight() / 2.0f;
        if (glyphs.length != 0) {
            float[] positions = this.textLine.getPositions();
            float[] widths = this.font.getWidths(glyphs);
            caretX = positions[Math.min(this.caretIndex, glyphs.length - 1) * 2];
            if (this.caretIndex == glyphs.length) {
                caretX += widths[glyphs.length - 1];
            }
            if (this.selectionOffset != 0) {
                float selectLeft = 0.0f;
                float selectRight = 0.0f;
                int offsetIndex = this.getOffsetCaretIndex();
                if (this.caretIndex < offsetIndex) {
                    selectLeft = caretX;
                    selectRight = positions[Math.min(offsetIndex, glyphs.length - 1) * 2];
                    if (offsetIndex == glyphs.length) {
                        selectRight += widths[glyphs.length - 1];
                    }
                } else {
                    selectLeft = positions[offsetIndex * 2];
                    selectRight = caretX;
                }
                try (Paint paint = new Paint();){
                    paint.setColor(3315709).setAlphaf(this.getAlpha());
                    paint.setMode(PaintMode.FILL);
                    canvas.drawRect(Rect.makeLTRB((float)selectLeft, (float)(this.getScaledContentY() * scale + (this.getScaledContentHeight() * scale - lineHeight) / 2.0f), (float)selectRight, (float)(this.getScaledContentY() * scale + (this.getScaledContentHeight() * scale - lineHeight) / 2.0f + lineHeight)), paint);
                }
                return;
            }
        }
        if (this.caretBlinkTicks >= 10) {
            return;
        }
        try (Paint paint = new Paint();){
            paint.setColor(textColor);
            paint.setMode(PaintMode.FILL);
            float caretWidth = 1.0f * scale;
            canvas.drawRect(Rect.makeXYWH((float)(caretX - caretWidth / 2.0f), (float)(this.getScaledContentY() * scale + (this.getScaledContentHeight() * scale - lineHeight) / 2.0f), (float)caretWidth, (float)lineHeight), paint);
        }
    }

    @Override
    public void charTyped(char ch, int mods) {
        if (this.selectionOffset != 0) {
            this.deleteChars(this.selectionOffset);
        }
        this.insertText(Character.toString(ch));
    }

    @Override
    public void keyPressed(int key, int scancode, int mods) {
        if (Bliss.instance().platform().isSelectAll(key)) {
            this.selectAll();
            return;
        }
        if (Bliss.instance().platform().isCopy(key)) {
            this.getSelectedText().ifPresent(Bliss.instance().platform()::setClipboard);
            return;
        }
        if (Bliss.instance().platform().isPaste(key)) {
            if (this.selectionOffset != 0) {
                this.deleteChars(this.selectionOffset);
            }
            this.insertText(Bliss.instance().platform().getClipboard());
            return;
        }
        if (Bliss.instance().platform().isCut(key)) {
            this.getSelectedText().ifPresent(selected -> {
                Bliss.instance().platform().setClipboard((String)selected);
                this.deleteChars(this.selectionOffset);
            });
            return;
        }
        switch (key) {
            case 259: {
                this.deleteText(this.selectionOffset == 0 ? -1 : this.selectionOffset);
                return;
            }
            case 261: {
                this.deleteText(this.selectionOffset == 0 ? 1 : this.selectionOffset);
                return;
            }
            case 262: {
                boolean select = Bliss.instance().platform().hasShiftDown();
                boolean word = Bliss.instance().platform().hasControlDown();
                if (select) {
                    this.setSelectionOffset(word ? this.getRightWordIndex(1) - this.caretIndex : this.selectionOffset + 1);
                } else {
                    this.setCaretIndex(word ? this.getRightWordIndex(1) : (this.selectionOffset != 0 ? Math.max(this.getOffsetCaretIndex(), this.caretIndex) : this.caretIndex + 1));
                }
                return;
            }
            case 263: {
                boolean select = Bliss.instance().platform().hasShiftDown();
                boolean word = Bliss.instance().platform().hasControlDown();
                if (select) {
                    this.setSelectionOffset(word ? this.getLeftWordIndex(1) - this.caretIndex : this.selectionOffset - 1);
                } else {
                    this.setCaretIndex(word ? this.getLeftWordIndex(1) : (this.selectionOffset != 0 ? Math.min(this.getOffsetCaretIndex(), this.caretIndex) : this.caretIndex - 1));
                }
                return;
            }
            case 268: {
                this.setCaretIndex(0);
                return;
            }
            case 269: {
                this.setCaretIndex(this.text.length());
                return;
            }
        }
    }

    private Optional<String> getSelectedText() {
        if (this.selectionOffset == 0) {
            return Optional.empty();
        }
        return Optional.of(this.selectionOffset < 0 ? this.text.substring(this.getOffsetCaretIndex(), this.caretIndex) : this.text.substring(this.caretIndex, this.getOffsetCaretIndex()));
    }

    private void insertText(String text) {
        String head = this.text.substring(0, this.caretIndex);
        String tail = this.text.substring(this.caretIndex);
        this.caretIndex += text.length();
        this.setText(head + text + tail);
    }

    private void deleteText(int count) {
        if (Bliss.instance().platform().hasControlDown()) {
            this.deleteWords(count);
        } else {
            this.deleteChars(count);
        }
    }

    public void deleteWords(int offset) {
        if (this.text.isEmpty()) {
            return;
        }
        if (offset < 0) {
            int wordIndex = this.getLeftWordIndex(offset);
            String head = this.text.substring(0, wordIndex);
            String tail = this.text.substring(this.caretIndex);
            this.caretIndex = wordIndex;
            this.setText(head + tail);
            return;
        }
        if (offset > 0) {
            int wordIndex = this.getRightWordIndex(offset);
            String head = this.text.substring(0, this.caretIndex);
            String tail = this.text.substring(wordIndex);
            this.setText(head + tail);
        }
    }

    private int getRightWordIndex(int count) {
        int startIndex;
        int wordCount = 0;
        boolean lastSpace = false;
        for (int i = startIndex = this.getOffsetCaretIndex(); i < this.text.length(); ++i) {
            boolean space = Character.isSpaceChar(this.text.charAt(i));
            if (!space && lastSpace && ++wordCount >= count) {
                return i;
            }
            lastSpace = space;
            if (!space) continue;
        }
        return this.text.length();
    }

    private int getLeftWordIndex(int count) {
        int index = 0;
        int wordCount = 0;
        boolean lastSpace = true;
        int fromIndex = this.getOffsetCaretIndex();
        for (int i = fromIndex - 1; i >= 0; --i) {
            if (Character.isSpaceChar(this.text.charAt(i))) {
                if (!lastSpace && ++wordCount >= count) break;
                lastSpace = true;
                continue;
            }
            lastSpace = false;
            index = i;
        }
        return index;
    }

    public void deleteChars(int offset) {
        if (this.text.isEmpty()) {
            return;
        }
        if (offset < 0) {
            int endIndex = Math.max(0, this.caretIndex + offset);
            String head = this.text.substring(0, endIndex);
            String tail = this.text.substring(this.caretIndex);
            this.caretIndex = endIndex;
            this.setText(head + tail);
            return;
        }
        if (offset > 0) {
            int endIndex = Math.min(this.caretIndex + offset, this.text.length());
            String head = this.text.substring(0, this.caretIndex);
            if (endIndex == this.text.length()) {
                this.setText(head);
                return;
            }
            String tail = this.text.substring(endIndex);
            this.setText(head + tail);
        }
    }

    private void setText(String text) {
        this.text = this.maxLength > 0 && text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
        this.refreshTextLine();
        this.setCaretIndex(this.caretIndex);
        this.clearSelection();
        if (this.responder != null) {
            this.responder.accept(this.text);
        }
    }

    private void refreshTextLine() {
        this.font = new Font(this.typeface, (float)((Integer)this.getStyle().fontSize.get()).intValue() * this.graphicsContext.scale());
        this.textLine = Shaper.makeShapeDontWrapOrReorder((FontMgr)this.fontManager).shapeLine(this.text, this.font);
    }

    @Override
    protected void layout() {
        this.refreshTextLine();
        super.layout();
    }

    @Override
    public void mouseEntered(double mouseX, double mouseY) {
        super.mouseEntered(mouseX, mouseY);
        this.updateCursor();
    }

    @Override
    public void mouseLeft(double mouseX, double mouseY) {
        super.mouseLeft(mouseX, mouseY);
        this.updateCursor();
    }

    @Override
    public boolean mousePressed(double mouseX, double mouseY, int button) {
        super.mousePressed(mouseX, mouseY, button);
        if (button != 0 || !this.isFocused()) {
            return false;
        }
        if (Bliss.instance().platform().hasShiftDown()) {
            this.setSelectionOffset(this.getCharIndexAt((float)mouseX) - this.caretIndex);
        } else {
            this.clearSelection();
            this.setCaretIndex(this.getCharIndexAt((float)mouseX));
        }
        return true;
    }

    private void setCaretIndex(int index) {
        this.caretBlinkTicks = 0;
        this.caretIndex = MathUtil.clamp(index, 0, this.text.length());
        if (this.selectionOffset == 0) {
            this.updateScrollOffset();
        } else {
            this.clearSelection();
        }
    }

    private int getOffsetCaretIndex() {
        return this.caretIndex + this.selectionOffset;
    }

    private void updateScrollOffset() {
        float[] positions = this.textLine.getPositions();
        if (positions.length == 0) {
            this.xOffset = 1.0f;
            return;
        }
        int offsetIndex = this.getOffsetCaretIndex();
        float[] widths = this.font.getWidths(this.textLine.getGlyphs());
        float scale = this.graphicsContext.scale();
        int glyphIndex = Math.min(offsetIndex, this.text.length() - 1);
        float glyphWidth = widths[glyphIndex];
        float glyphX = positions[glyphIndex * 2];
        if (offsetIndex == this.text.length()) {
            glyphX += glyphWidth;
        }
        if (glyphX + this.xOffset > this.getScaledContentWidth() * scale) {
            this.xOffset = this.getScaledContentWidth() * scale - glyphX - 1.0f;
        } else if (glyphX + this.xOffset < 0.0f) {
            this.xOffset = -glyphX + 1.0f;
        }
    }

    private void selectAll() {
        this.setCaretIndex(0);
        this.setSelectionOffset(this.text.length());
    }

    private void clearSelection() {
        this.setSelectionOffset(0);
    }

    private void setSelectionOffset(int offset) {
        this.selectionOffset = offset;
        if (this.selectionOffset != 0) {
            int offsetIndex = this.getOffsetCaretIndex();
            if (offsetIndex > this.text.length()) {
                this.selectionOffset = this.text.length() - this.caretIndex;
            } else if (offsetIndex < 0) {
                this.selectionOffset = -this.caretIndex;
            }
        }
        this.updateScrollOffset();
    }

    @Override
    public void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        this.setSelectionOffset(this.getCharIndexAt((float)(mouseX + deltaX)) - this.caretIndex);
    }

    private int getCharIndexAt(float x) {
        float scale = this.graphicsContext.scale();
        short[] glyphs = this.textLine.getGlyphs();
        if (glyphs.length == 0) {
            return 0;
        }
        float[] positions = this.textLine.getPositions();
        float[] widths = this.font.getWidths(glyphs);
        for (int i = 0; i < glyphs.length; ++i) {
            float width = widths[i] / scale;
            float position = positions[i * 2] / scale + this.getScaledContentX() + this.xOffset / scale;
            if (x >= position) {
                if (x <= position + width / 2.0f) {
                    return i;
                }
                if (!(x <= position + width)) continue;
                return i + 1;
            }
            if (i != 0) continue;
            return 0;
        }
        return glyphs.length;
    }

    private void updateCursor() {
        this.graphicsContext.setCursor(this.isHovered() ? Cursor.IBEAM : Cursor.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TextBlob makeBlobFromPos(short[] glyphs, float[] floatPos, Font font) {
        try {
            Stats.onNativeCall();
            long ptr = TextBlob._nMakeFromPos((short[])glyphs, (float[])floatPos, (long)Native.getPtr((Native)font));
            TextBlob textBlob = ptr == 0L ? null : new TextBlob(ptr);
            return textBlob;
        }
        finally {
            Reference.reachabilityFence(font);
        }
    }
}

