/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.selector.combinator;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import sm0keysa1m0n.bliss.style.StyleNode;
import sm0keysa1m0n.bliss.style.selector.Selector;
import sm0keysa1m0n.bliss.style.selector.StyleNodeState;
import sm0keysa1m0n.bliss.style.selector.combinator.Combinator;

public class SiblingCombinator
implements Combinator {
    private final boolean direct;

    public SiblingCombinator(boolean direct) {
        this.direct = direct;
    }

    @Override
    public Optional<Combinator.Result> match(StyleNode node, Selector selector) {
        return this.checkSibling(node, false, selector);
    }

    private Optional<Combinator.Result> checkSibling(StyleNode node, boolean reverse, Selector selector) {
        List<? extends StyleNode> children;
        StyleNode parent = node.getParent();
        if (parent == null) {
            return Optional.empty();
        }
        int siblingIndex = node.getIndex() + (reverse ? 1 : -1);
        if (siblingIndex == (children = parent.getChildStyles()).size() || siblingIndex < 0) {
            return Optional.empty();
        }
        StyleNode sibling = parent.getChildStyles().get(siblingIndex);
        Optional<Combinator.Result> result = selector.match(sibling).map(nodeStates -> new Combinator.Result(sibling, (Set<StyleNodeState>)nodeStates));
        return this.direct ? result : result.or(() -> this.checkSibling(sibling, reverse, selector));
    }

    @Override
    public List<Combinator.Result> reverseMatch(StyleNode node, Selector selector) {
        return this.checkSibling(node, true, selector).map(List::of).orElse(List.of());
    }

    public String toString() {
        return "Combinator[" + (this.direct ? "+" : "~") + "]";
    }
}

