/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.selector.combinator;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import sm0keysa1m0n.bliss.style.StyleNode;
import sm0keysa1m0n.bliss.style.selector.Selector;
import sm0keysa1m0n.bliss.style.selector.StyleNodeState;
import sm0keysa1m0n.bliss.style.selector.combinator.Combinator;

public class DescendantCombinator
implements Combinator {
    private final boolean direct;

    public DescendantCombinator(boolean direct) {
        this.direct = direct;
    }

    @Override
    public Optional<Combinator.Result> match(StyleNode node, Selector selector) {
        StyleNode parent = node.getParent();
        if (parent == null) {
            return Optional.empty();
        }
        if (this.direct) {
            return selector.match(parent).map(nodeStates -> new Combinator.Result(parent, (Set<StyleNodeState>)nodeStates));
        }
        Combinator.Result result = null;
        for (StyleNode current = parent; current != null; current = current.getParent()) {
            Optional<Set<StyleNodeState>> currentResult = selector.match(current);
            if (!currentResult.isPresent()) continue;
            result = new Combinator.Result(current, currentResult.get());
        }
        return Optional.ofNullable(result);
    }

    @Override
    public List<Combinator.Result> reverseMatch(StyleNode node, Selector selector) {
        return this.matchChildren(node, selector);
    }

    private List<Combinator.Result> matchChildren(StyleNode node, Selector selector) {
        ArrayList<Combinator.Result> results = new ArrayList<Combinator.Result>();
        for (StyleNode styleNode : node.getChildStyles()) {
            selector.match(styleNode).ifPresent(nodeStates -> results.add(new Combinator.Result(child, (Set<StyleNodeState>)nodeStates)));
            results.addAll(this.matchChildren(styleNode, selector));
        }
        return results;
    }

    public String toString() {
        return "Combinator[" + (this.direct ? ">" : " ") + "]";
    }
}

