/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.parser.value;

import org.jdesktop.core.animation.timing.Interpolator;
import org.jdesktop.core.animation.timing.interpolators.LinearInterpolator;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.animation.CubicBezierInterpolator;
import sm0keysa1m0n.bliss.style.parser.ParsedFunction;
import sm0keysa1m0n.bliss.style.parser.ParserException;
import sm0keysa1m0n.bliss.style.parser.StyleReader;

public class InterpolatorParser {
    public static final Interpolator EASE = new CubicBezierInterpolator(0.25, 0.1, 0.25, 1.0);
    public static final Interpolator EASE_IN = new CubicBezierInterpolator(0.42, 0.0, 1.0, 1.0);
    public static final Interpolator EASE_OUT = new CubicBezierInterpolator(0.0, 0.0, 0.58, 1.0);
    public static final Interpolator EASE_IN_OUT = new CubicBezierInterpolator(0.42, 0.0, 0.58, 1.0);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Interpolator parse(StyleReader reader) throws ParserException {
        ParsedFunction func = reader.readFunction();
        if (func != null) {
            switch (func.name()) {
                case "cubic-bezier": {
                    String[] points = func.arguments().split(",");
                    double[] pointsArray = new double[4];
                    for (int i = 0; i < pointsArray.length; ++i) {
                        pointsArray[i] = Double.parseDouble(points[i].strip());
                    }
                    return new CubicBezierInterpolator(pointsArray[0], pointsArray[1], pointsArray[2], pointsArray[3]);
                }
                default: {
                    throw new ParserException("Unknown interpolator: " + func.name());
                }
            }
        }
        String keyword = reader.readUnquotedString();
        if (keyword == null) {
            return null;
        }
        switch (keyword) {
            case "linear": {
                LinearInterpolator linearInterpolator = LinearInterpolator.getInstance();
                return linearInterpolator;
            }
            case "ease": {
                LinearInterpolator linearInterpolator = EASE;
                return linearInterpolator;
            }
            case "ease-in": {
                LinearInterpolator linearInterpolator = EASE_IN;
                return linearInterpolator;
            }
            case "ease-out": {
                LinearInterpolator linearInterpolator = EASE_OUT;
                return linearInterpolator;
            }
            default: {
                throw new ParserException("Unknown interpolator: " + keyword);
            }
        }
    }
}

