/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.parser.value;

import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.style.parser.ParsedFunction;
import sm0keysa1m0n.bliss.style.parser.ParserException;
import sm0keysa1m0n.bliss.style.parser.StyleReader;
import sm0keysa1m0n.bliss.style.parser.value.NamedColors;

public class ColorParser {
    private static String doubleChars(String input) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            builder.append(ch);
            builder.append(ch);
        }
        return builder.toString();
    }

    private static ParserException invalidHexColor(int index) {
        return new ParserException("Invalid hex color at index " + index);
    }

    @Nullable
    public static Color parse(StyleReader reader) throws ParserException {
        int start = reader.getCursor();
        if (reader.peek() == '#') {
            reader.skip();
            String hexValue = reader.readUnquotedString();
            if (hexValue == null) {
                throw ColorParser.invalidHexColor(start);
            }
            try {
                return Color.create(switch (hexValue.length()) {
                    case 3 -> Integer.parseUnsignedInt(ColorParser.doubleChars(hexValue), 16) + -16777216;
                    case 4 -> Integer.parseUnsignedInt(ColorParser.doubleChars(hexValue), 16);
                    case 6 -> Integer.parseUnsignedInt(hexValue, 16) + -16777216;
                    case 8 -> Integer.parseUnsignedInt(hexValue, 16);
                    default -> throw ColorParser.invalidHexColor(start);
                });
            }
            catch (NumberFormatException e) {
                throw ColorParser.invalidHexColor(start);
            }
        }
        ParsedFunction func = reader.readFunction();
        if (func != null) {
            boolean alpha = func.name().equals("rgba");
            String[] colorNames = func.arguments().split(",");
            float redValue = 0.0f;
            float greenValue = 0.0f;
            float blueValue = 0.0f;
            float alphaValue = 1.0f;
            for (int i = 0; i < colorNames.length; ++i) {
                float colorValue;
                float floatValue;
                String value = colorNames[i].trim();
                boolean percentage = value.endsWith("%");
                float f = floatValue = percentage ? Float.parseFloat(value.substring(0, value.length() - 1)) / 100.0f : Float.parseFloat(value);
                if (alpha && i == 3) {
                    alphaValue = floatValue;
                    continue;
                }
                float f2 = colorValue = percentage ? floatValue : floatValue / 255.0f;
                if (i == 0) {
                    redValue = colorValue;
                    continue;
                }
                if (i == 1) {
                    greenValue = colorValue;
                    continue;
                }
                if (i != 2) continue;
                blueValue = colorValue;
            }
            return Color.create(redValue, greenValue, blueValue, alphaValue);
        }
        String keyword = reader.readUnquotedString();
        if (keyword == null) {
            return null;
        }
        Color color = NamedColors.getColor(keyword);
        if (color != null) {
            return color;
        }
        reader.setCursor(start);
        return null;
    }
}

