/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.parser.value;

import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.BoxShadow;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.style.parser.ParserException;
import sm0keysa1m0n.bliss.style.parser.StyleReader;
import sm0keysa1m0n.bliss.style.parser.value.ColorParser;

public class BoxShadowParser {
    @Nullable
    private static Boolean parseInset(StyleReader reader) {
        int start = reader.getCursor();
        String keyword = reader.readUnquotedString();
        if (keyword == null) {
            return null;
        }
        if (keyword.equals("inset")) {
            return true;
        }
        reader.setCursor(start);
        return null;
    }

    @Nullable
    public static BoxShadow parse(StyleReader reader) throws ParserException {
        Float xOffset;
        Boolean inset;
        Color color = ColorParser.parse(reader);
        if (color != null) {
            reader.skipWhitespace();
        }
        if ((inset = BoxShadowParser.parseInset(reader)) != null) {
            reader.skipWhitespace();
        }
        if (color == null && (color = ColorParser.parse(reader)) != null) {
            reader.skipWhitespace();
        }
        if ((xOffset = reader.readFloat()) == null) {
            if (color == null) {
                return null;
            }
            throw new ParserException("X-offset expected at index " + reader.getCursor());
        }
        String xOffsetUnit = reader.readUnquotedString();
        if (xOffset.floatValue() != 0.0f && xOffsetUnit == null) {
            throw new ParserException("X-offset unit expected at index " + reader.getCursor());
        }
        reader.skipWhitespace();
        Float yOffset = reader.readFloat();
        if (yOffset == null) {
            throw new ParserException("Y-offset expected at index " + reader.getCursor());
        }
        String yOffsetUnit = reader.readUnquotedString();
        if (yOffset.floatValue() != 0.0f && yOffsetUnit == null) {
            throw new ParserException("Y-offset unit expected at index " + reader.getCursor());
        }
        reader.skipWhitespace();
        Float blurRadius = reader.readFloat();
        if (blurRadius == null) {
            blurRadius = Float.valueOf(0.0f);
        } else {
            String blurRadiusUnit = reader.readUnquotedString();
            if (blurRadius.floatValue() != 0.0f && blurRadiusUnit == null) {
                throw new ParserException("Blur radius unit expected at index " + reader.getCursor());
            }
            reader.skipWhitespace();
        }
        Float spreadRadius = reader.readFloat();
        if (spreadRadius == null) {
            spreadRadius = Float.valueOf(0.0f);
        } else {
            String spreadRadiusUnit = reader.readUnquotedString();
            if (spreadRadius.floatValue() != 0.0f && spreadRadiusUnit == null) {
                throw new ParserException("Spread radius unit expected at index " + reader.getCursor());
            }
            reader.skipWhitespace();
        }
        if (inset == null && (inset = BoxShadowParser.parseInset(reader)) != null) {
            reader.skipWhitespace();
        }
        if (color == null) {
            color = ColorParser.parse(reader);
            if (color == null) {
                color = Color.BLACK;
            } else {
                reader.skipWhitespace();
            }
        }
        if (inset == null && (inset = BoxShadowParser.parseInset(reader)) == null) {
            inset = false;
        }
        return new BoxShadow(inset, xOffset.floatValue(), yOffset.floatValue(), blurRadius.floatValue(), spreadRadius.floatValue(), color);
    }
}

