/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.parser;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.style.parser.NumberedLineIterator;
import sm0keysa1m0n.bliss.style.selector.CompoundSelector;
import sm0keysa1m0n.bliss.style.selector.Selector;
import sm0keysa1m0n.bliss.style.selector.SingleSelector;
import sm0keysa1m0n.bliss.style.selector.combinator.Combinator;
import sm0keysa1m0n.bliss.style.selector.combinator.DescendantCombinator;
import sm0keysa1m0n.bliss.style.selector.combinator.SiblingCombinator;

class StyleSelectorParser {
    private StyleSelectorParser() {
    }

    static Selector[] readSelectors(String currentLine, NumberedLineIterator iterator) {
        StringBuilder selectorBuilder = new StringBuilder(currentLine.trim());
        while (!currentLine.endsWith("{")) {
            currentLine = iterator.nextLine().trim();
            selectorBuilder.append(currentLine);
        }
        Selector[] test = StyleSelectorParser.readSelectorList(selectorBuilder.toString().replace("{", "").trim());
        return test;
    }

    static Selector[] readSelectorList(String selector) {
        if (selector.contains(",")) {
            Selector[] selectors = new Selector[StringUtils.countMatches((CharSequence)selector, (CharSequence)",") + 1];
            int i = 0;
            for (String subSelector : selector.split(",")) {
                selectors[i] = StyleSelectorParser.readSingleSelector(StyleSelectorParser.cleanSelector(subSelector.trim()));
                ++i;
            }
            return selectors;
        }
        return new Selector[]{StyleSelectorParser.readSingleSelector(StyleSelectorParser.cleanSelector(selector))};
    }

    static Selector readSingleSelector(String selectorStr) {
        int bracketLevel = 0;
        char[] chars = selectorStr.toCharArray();
        CompoundSelector selectorStack = new CompoundSelector();
        Combinator combinator = Combinator.AND;
        StringBuilder currentElement = null;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch == '(') {
                ++bracketLevel;
                if (currentElement == null) continue;
                currentElement.append(ch);
                continue;
            }
            if (ch == ')') {
                --bracketLevel;
                if (currentElement == null) continue;
                currentElement.append(ch);
                continue;
            }
            if (bracketLevel != 0) {
                if (bracketLevel < 0) {
                    throw new IllegalStateException("Uneven amount of brackets in: " + selectorStr);
                }
                if (currentElement == null) continue;
                currentElement.append(ch);
                continue;
            }
            Combinator nextCombinator = StyleSelectorParser.tryParseCombinator(ch);
            if (nextCombinator != null) {
                selectorStack.push(StyleSelectorParser.parseElement(currentElement.toString()), combinator);
                currentElement = null;
                combinator = nextCombinator;
                continue;
            }
            if (ch == ':' || ch == '.' || ch == '*' || ch == '#') {
                if (currentElement != null) {
                    selectorStack.push(StyleSelectorParser.parseElement(currentElement.toString()), combinator);
                    combinator = Combinator.AND;
                }
                currentElement = new StringBuilder();
                currentElement.append(ch);
                continue;
            }
            if (currentElement == null) {
                currentElement = new StringBuilder();
            }
            currentElement.append(ch);
        }
        if (currentElement != null) {
            selectorStack.push(StyleSelectorParser.parseElement(currentElement.toString()), combinator);
        }
        return selectorStack;
    }

    @Nullable
    static Combinator tryParseCombinator(char ch) {
        return switch (ch) {
            case '>' -> new DescendantCombinator(true);
            case ' ' -> new DescendantCombinator(false);
            case '+' -> new SiblingCombinator(true);
            case '~' -> new SiblingCombinator(false);
            default -> null;
        };
    }

    static SingleSelector parseElement(String part) {
        if (part.startsWith(":")) {
            String pseudoClass = part.substring(1);
            SingleSelector structural = SingleSelector.parseStructural(pseudoClass, StyleSelectorParser::readSelectorList);
            if (structural != null) {
                return structural;
            }
            return SingleSelector.ofState(pseudoClass);
        }
        if (part.startsWith("*")) {
            return SingleSelector.WILDCARD;
        }
        if (part.startsWith("#")) {
            return SingleSelector.ofId(part.substring(1));
        }
        if (part.startsWith(".")) {
            return SingleSelector.ofClass(part.substring(1));
        }
        return SingleSelector.ofType(part);
    }

    static String cleanSelector(String selector) {
        StringBuilder cleanSelector = new StringBuilder(selector);
        for (int i = 0; i < cleanSelector.length(); ++i) {
            if (i == 0 || cleanSelector.charAt(i) != ' ') continue;
            int count = 1;
            while (cleanSelector.charAt(i + count) == ' ') {
                ++count;
            }
            if (!StyleSelectorParser.isToken(cleanSelector.charAt(i + count)) && !StyleSelectorParser.isToken(cleanSelector.charAt(i - 1))) {
                cleanSelector.replace(i, i + count, " ");
                continue;
            }
            cleanSelector.delete(i, i + count);
        }
        return cleanSelector.toString();
    }

    static boolean isToken(char c) {
        return c == '>' || c == '+' || c == '~';
    }
}

