/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sm0keysa1m0n.bliss.style.PropertyDispatcher;
import sm0keysa1m0n.bliss.style.StyleList;
import sm0keysa1m0n.bliss.style.StyleNode;
import sm0keysa1m0n.bliss.style.StyleProperty;
import sm0keysa1m0n.bliss.style.StyleRule;
import sm0keysa1m0n.bliss.style.StyleTransition;
import sm0keysa1m0n.bliss.style.parser.ParserException;
import sm0keysa1m0n.bliss.style.parser.TransitionParser;
import sm0keysa1m0n.bliss.style.selector.StyleNodeState;

public class StyleManager {
    private static final Logger logger = LoggerFactory.getLogger(StyleManager.class);
    private final Map<String, PropertyDispatcher<?>> properties = new HashMap();
    private final List<PropertyDispatcher<?>> listeners = new ArrayList();
    private final StyleNode owner;
    private int state;

    public StyleManager(StyleNode owner) {
        this.owner = owner;
    }

    public StyleNode getOwner() {
        return this.owner;
    }

    public int getState() {
        return this.state;
    }

    public void addState(int state) {
        this.state |= state;
    }

    public void removeState(int state) {
        this.state &= ~state;
    }

    public boolean hasState(int state) {
        return (this.state & state) == state;
    }

    public boolean toggleState(int state) {
        if (this.hasState(state)) {
            this.removeState(state);
            return false;
        }
        this.addState(state);
        return true;
    }

    public void addListener(PropertyDispatcher<?> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PropertyDispatcher<?> listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        for (PropertyDispatcher<?> listener : this.listeners) {
            listener.refreshState();
        }
    }

    public void parseInline(String css) throws ParserException {
        for (String propertyStr : css.split(";")) {
            String[] split = propertyStr.split(":", 2);
            String propertyName = split[0].trim();
            PropertyDispatcher<?> property = this.properties.get(propertyName);
            if (property == null) continue;
            property.defineState(split[1].trim(), 1000, Set.of());
        }
    }

    public Collection<PropertyDispatcher<?>> getProperties() {
        return this.properties.values();
    }

    public <T> PropertyDispatcher<T> registerProperty(PropertyDispatcher<T> property) {
        this.properties.put(property.getName(), property);
        return property;
    }

    public void refresh() {
        StyleList styleList = this.owner.getStyleList();
        if (styleList == null) {
            return;
        }
        Map<StyleRule, Set<StyleNodeState>> rules = styleList.getRulesMatching(this.owner);
        ArrayList transitions = new ArrayList();
        this.properties.values().forEach(PropertyDispatcher::reset);
        for (Map.Entry<StyleRule, Set<StyleNodeState>> ruleEntry : rules.entrySet()) {
            StyleRule rule = ruleEntry.getKey();
            Set<StyleNodeState> nodeStates = ruleEntry.getValue();
            TransitionParser transitionParser = null;
            for (StyleProperty property : rule.properties()) {
                PropertyDispatcher<?> dispatcher = this.properties.get(property.name());
                if (dispatcher != null) {
                    try {
                        dispatcher.defineState(property.value(), rule.selector().getSpecificity(), nodeStates);
                    }
                    catch (ParserException e) {
                        logger.warn("Failed to parse property: {}", (Object)property, (Object)e);
                    }
                    continue;
                }
                if (!TransitionParser.isTransitionProperty(property.name())) continue;
                if (transitionParser == null) {
                    transitionParser = new TransitionParser();
                }
                try {
                    transitionParser.tryParse(property.name(), property.value());
                }
                catch (ParserException e) {
                    logger.warn("Failed to parse transition property: {}", (Object)property, (Object)e);
                }
            }
            if (transitionParser == null) continue;
            try {
                transitionParser.build().ifPresent(transitions::add);
            }
            catch (ParserException e) {
                logger.warn("Failed to parse transition: ", (Throwable)e);
            }
        }
        for (StyleTransition transition : transitions) {
            transition.apply(this.properties);
        }
        this.properties.values().forEach(PropertyDispatcher::refreshState);
        this.owner.styleRefreshed(styleList.createFontManager());
    }
}

