/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.layout.yoga;

import org.jetbrains.annotations.Nullable;
import org.lwjgl.util.yoga.YGMeasureFunc;
import org.lwjgl.util.yoga.YGMeasureFuncI;
import org.lwjgl.util.yoga.YGSize;
import org.lwjgl.util.yoga.Yoga;
import sm0keysa1m0n.bliss.Length;
import sm0keysa1m0n.bliss.Overflow;
import sm0keysa1m0n.bliss.Size;
import sm0keysa1m0n.bliss.layout.Align;
import sm0keysa1m0n.bliss.layout.Layout;
import sm0keysa1m0n.bliss.layout.MeasureMode;
import sm0keysa1m0n.bliss.layout.PositionType;
import sm0keysa1m0n.bliss.layout.yoga.YogaUtil;
import sm0keysa1m0n.bliss.view.ViewStyle;

public final class YogaLayout
implements Layout {
    private static final MeasureMode[] measureModes = new MeasureMode[]{MeasureMode.UNDEFINED, MeasureMode.EXACTLY, MeasureMode.AT_MOST};
    private static final Overflow[] overflows = new Overflow[]{Overflow.VISIBLE, Overflow.HIDDEN, Overflow.SCROLL};
    final long node = Yoga.YGNodeNew();
    private boolean measureFunctionPresent;
    private boolean closed;

    @Override
    public void setAll(ViewStyle style) {
        this.setTopBorderWidth(((Length)style.borderTopWidth.get()).fixed());
        this.setRightBorderWidth(((Length)style.borderRightWidth.get()).fixed());
        this.setBottomBorderWidth(((Length)style.borderBottomWidth.get()).fixed());
        this.setLeftBorderWidth(((Length)style.borderLeftWidth.get()).fixed());
        ((Length)style.paddingTop.get()).dispatch(this::setTopPadding, this::setTopPaddingPercent);
        ((Length)style.paddingRight.get()).dispatch(this::setRightPadding, this::setRightPaddingPercent);
        ((Length)style.paddingBottom.get()).dispatch(this::setBottomPadding, this::setBottomPaddingPercent);
        ((Length)style.paddingLeft.get()).dispatch(this::setLeftPadding, this::setLeftPaddingPercent);
        ((Length)style.marginTop.get()).dispatch(this::setTopMargin, this::setTopMarginPercent, this::setTopMarginAuto);
        ((Length)style.marginRight.get()).dispatch(this::setRightMargin, this::setRightMarginPercent, this::setRightMarginAuto);
        ((Length)style.marginBottom.get()).dispatch(this::setBottomMargin, this::setBottomMarginPercent, this::setBottomMarginAuto);
        ((Length)style.marginLeft.get()).dispatch(this::setLeftMargin, this::setLeftMarginPercent, this::setLeftMarginAuto);
        this.setPositionType((PositionType)((Object)style.position.get()));
        this.setFlexGrow(((Float)style.flexGrow.get()).floatValue());
        this.setFlexShrink(((Float)style.flexShrink.get()).floatValue());
        ((Length)style.flexBasis.get()).dispatch(this::setFlexBasis, this::setFlexBasisPercent, this::setFlexBasisAuto);
        this.setFlex(((Float)style.flex.get()).floatValue());
        this.setAspectRatio(((Float)style.aspectRatio.get()).floatValue());
        this.setAlignSelf((Align)((Object)style.alignSelf.get()));
        ((Length)style.width.get()).dispatch(this::setWidth, this::setWidthPercent, this::setWidthAuto);
        ((Length)style.height.get()).dispatch(this::setHeight, this::setHeightPercent, this::setHeightAuto);
        ((Length)style.minWidth.get()).dispatch(this::setMinWidth, this::setMinWidthPercent);
        ((Length)style.minHeight.get()).dispatch(this::setMinHeight, this::setMinHeightPercent);
        this.setOverflow((Overflow)((Object)style.overflow.get()));
    }

    @Override
    public void setOverflow(Overflow overflow) {
        this.checkClosed();
        for (int i = 0; i < overflows.length; ++i) {
            if (overflow != overflows[i]) continue;
            Yoga.YGNodeStyleSetOverflow((long)this.node, (int)i);
            return;
        }
        throw new IllegalStateException("Unknown value: " + overflow);
    }

    @Override
    public void setBorderWidth(float width) {
        this.checkClosed();
        Yoga.YGNodeStyleSetBorder((long)this.node, (int)8, (float)width);
    }

    @Override
    public void setLeftBorderWidth(float width) {
        this.checkClosed();
        Yoga.YGNodeStyleSetBorder((long)this.node, (int)0, (float)width);
    }

    @Override
    public void setRightBorderWidth(float width) {
        this.checkClosed();
        Yoga.YGNodeStyleSetBorder((long)this.node, (int)2, (float)width);
    }

    @Override
    public void setTopBorderWidth(float width) {
        this.checkClosed();
        Yoga.YGNodeStyleSetBorder((long)this.node, (int)1, (float)width);
    }

    @Override
    public void setBottomBorderWidth(float width) {
        this.checkClosed();
        Yoga.YGNodeStyleSetBorder((long)this.node, (int)3, (float)width);
    }

    @Override
    public void setLeftPadding(float leftPadding) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)0, (float)leftPadding);
    }

    @Override
    public void setLeftPaddingPercent(float leftPaddingPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)0, (float)leftPaddingPercent);
    }

    @Override
    public void setRightPadding(float rightPadding) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)2, (float)rightPadding);
    }

    @Override
    public void setRightPaddingPercent(float rightPaddingPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)2, (float)rightPaddingPercent);
    }

    @Override
    public void setTopPadding(float topPadding) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)1, (float)topPadding);
    }

    @Override
    public void setTopPaddingPercent(float topPaddingPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)1, (float)topPaddingPercent);
    }

    @Override
    public void setBottomPadding(float bottomPadding) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)3, (float)bottomPadding);
    }

    @Override
    public void setBottomPaddingPercent(float bottomPaddingPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)3, (float)bottomPaddingPercent);
    }

    @Override
    public void setPadding(float padding) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)8, (float)padding);
    }

    @Override
    public void setPaddingPercent(float paddingPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)8, (float)paddingPercent);
    }

    @Override
    public void setLeftMargin(float leftMargin) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)0, (float)leftMargin);
    }

    @Override
    public void setLeftMarginPercent(float leftMarginPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)0, (float)leftMarginPercent);
    }

    @Override
    public void setRightMargin(float rightMargin) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)2, (float)rightMargin);
    }

    @Override
    public void setRightMarginPercent(float rightMarginPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)2, (float)rightMarginPercent);
    }

    @Override
    public void setTopMargin(float topMargin) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)1, (float)topMargin);
    }

    @Override
    public void setTopMarginPercent(float topMarginPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)1, (float)topMarginPercent);
    }

    @Override
    public void setBottomMargin(float bottomMargin) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)3, (float)bottomMargin);
    }

    @Override
    public void setBottomMarginPercent(float bottomMarginPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)3, (float)bottomMarginPercent);
    }

    @Override
    public void setMargin(float margin) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)8, (float)margin);
    }

    @Override
    public void setMarginPercent(float marginPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)8, (float)marginPercent);
    }

    @Override
    public void setLeftMarginAuto() {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)0);
    }

    @Override
    public void setRightMarginAuto() {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)2);
    }

    @Override
    public void setTopMarginAuto() {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)1);
    }

    @Override
    public void setBottomMarginAuto() {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)3);
    }

    @Override
    public void setMarginAuto() {
        this.checkClosed();
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)8);
    }

    @Override
    public void setPositionType(PositionType positionType) {
        this.checkClosed();
        Yoga.YGNodeStyleSetPositionType((long)this.node, (int)YogaUtil.getPositionType(positionType));
    }

    @Override
    public void setFlexGrow(float flexGrow) {
        this.checkClosed();
        Yoga.YGNodeStyleSetFlexGrow((long)this.node, (float)flexGrow);
    }

    @Override
    public void setFlexShrink(float flexShrink) {
        this.checkClosed();
        Yoga.YGNodeStyleSetFlexShrink((long)this.node, (float)flexShrink);
    }

    @Override
    public void setFlexBasis(float flexBasis) {
        this.checkClosed();
        Yoga.YGNodeStyleSetFlexBasis((long)this.node, (float)flexBasis);
    }

    @Override
    public void setFlexBasisPercent(float flexBasisPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetFlexBasisPercent((long)this.node, (float)flexBasisPercent);
    }

    @Override
    public void setFlexBasisAuto() {
        this.checkClosed();
        Yoga.YGNodeStyleSetFlexBasisAuto((long)this.node);
    }

    @Override
    public void setFlex(float flex) {
        this.checkClosed();
        Yoga.YGNodeStyleSetFlex((long)this.node, (float)flex);
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        this.checkClosed();
        Yoga.YGNodeStyleSetAspectRatio((long)this.node, (float)aspectRatio);
    }

    @Override
    public void setAlignSelf(Align align) {
        this.checkClosed();
        Yoga.YGNodeStyleSetAlignSelf((long)this.node, (int)YogaUtil.getAlign(align));
    }

    @Override
    public void setWidth(float width) {
        this.checkClosed();
        Yoga.YGNodeStyleSetWidth((long)this.node, (float)width);
    }

    @Override
    public void setWidthPercent(float widthPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetWidthPercent((long)this.node, (float)widthPercent);
    }

    @Override
    public void setWidthAuto() {
        this.checkClosed();
        Yoga.YGNodeStyleSetWidthAuto((long)this.node);
    }

    @Override
    public void setMaxWidth(float maxWidth) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMaxWidth((long)this.node, (float)maxWidth);
    }

    @Override
    public void setMaxWidthPercent(float maxWidthPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMaxWidthPercent((long)this.node, (float)maxWidthPercent);
    }

    @Override
    public void setHeight(float height) {
        this.checkClosed();
        Yoga.YGNodeStyleSetHeight((long)this.node, (float)height);
    }

    @Override
    public void setHeightPercent(float heightPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetHeightPercent((long)this.node, (float)heightPercent);
    }

    @Override
    public void setHeightAuto() {
        this.checkClosed();
        Yoga.YGNodeStyleSetHeightAuto((long)this.node);
    }

    @Override
    public void setMaxHeight(float maxHeight) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMaxHeight((long)this.node, (float)maxHeight);
    }

    @Override
    public void setMaxHeightPercent(float maxHeightPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMaxHeightPercent((long)this.node, (float)maxHeightPercent);
    }

    @Override
    public void setMinWidth(float minWidth) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMinWidth((long)this.node, (float)minWidth);
    }

    @Override
    public void setMinWidthPercent(float minWidthPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMinWidthPercent((long)this.node, (float)minWidthPercent);
    }

    @Override
    public void setMinHeight(float minHeight) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMinHeight((long)this.node, (float)minHeight);
    }

    @Override
    public void setMinHeightPercent(float minHeightPercent) {
        this.checkClosed();
        Yoga.YGNodeStyleSetMinHeightPercent((long)this.node, (float)minHeightPercent);
    }

    @Override
    public Overflow getOverflow() {
        this.checkClosed();
        return overflows[Yoga.YGNodeStyleGetOverflow((long)this.node)];
    }

    @Override
    public float getX() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetLeft((long)this.node);
    }

    @Override
    public float getLeftPadding() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetPadding((long)this.node, (int)0);
    }

    @Override
    public float getLeftBorder() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetBorder((long)this.node, (int)0);
    }

    @Override
    public float getRightPadding() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetPadding((long)this.node, (int)2);
    }

    @Override
    public float getRightBorder() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetBorder((long)this.node, (int)2);
    }

    @Override
    public float getY() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetTop((long)this.node);
    }

    @Override
    public float getTopPadding() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetPadding((long)this.node, (int)1);
    }

    @Override
    public float getTopBorder() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetBorder((long)this.node, (int)1);
    }

    @Override
    public float getBottomPadding() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetPadding((long)this.node, (int)3);
    }

    @Override
    public float getBottomBorder() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetBorder((long)this.node, (int)3);
    }

    @Override
    public float getWidth() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetWidth((long)this.node);
    }

    @Override
    public float getHeight() {
        this.checkClosed();
        return Yoga.YGNodeLayoutGetHeight((long)this.node);
    }

    @Override
    public void markDirty() {
        this.checkClosed();
        if (!this.measureFunctionPresent) {
            throw new IllegalStateException("Layout must have a measure function in order to mark it as dirty.");
        }
        Yoga.YGNodeMarkDirty((long)this.node);
    }

    @Override
    public void close() {
        this.checkClosed();
        this.closed = true;
        Yoga.YGNodeFree((long)this.node);
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Layout has been closed.");
        }
    }

    @Override
    public void setMeasureFunction(@Nullable Layout.MeasureFunction measureFunction) {
        this.checkClosed();
        this.measureFunctionPresent = measureFunction != null;
        Yoga.YGNodeSetMeasureFunc((long)this.node, (YGMeasureFuncI)(measureFunction == null ? null : (node, width, widthMode, height, heightMode) -> {
            Size size = measureFunction.measure(measureModes[widthMode], width, measureModes[heightMode], height);
            return YGMeasureFunc.toLong((YGSize)YGSize.create().width(size.width()).height(size.height()));
        }));
    }
}

