/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import org.jdesktop.core.animation.timing.Evaluator;
import org.jdesktop.core.animation.timing.evaluators.KnownEvaluators;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.util.MathUtil;

public record Color(float[] components4f, int[] components4i, int hex) {
    private final float[] components4f;
    private final int[] components4i;
    public static final int FULL_ALPHA = -16777216;
    public static final Color TRANSPARENT;
    public static final Color BLACK;
    public static final Color DARK_BLUE;
    public static final Color DARK_GREEN;
    public static final Color DARK_AQUA;
    public static final Color DARK_RED;
    public static final Color DARK_PURPLE;
    public static final Color GOLD;
    public static final Color GRAY;
    public static final Color DARK_GRAY;
    public static final Color BLUE;
    public static final Color GREEN;
    public static final Color AQUA;
    public static final Color RED;
    public static final Color LIGHT_PURPLE;
    public static final Color YELLOW;
    public static final Color WHITE;
    public static final Color BLUE_C;
    public static final Color GRAY_224;
    private static final Color[] VANILLA_COLORS;

    public static Color parseWithFullAlpha(String hex) {
        return Color.parseWithAlpha(hex, 1.0f);
    }

    public static Color parseWithAlpha(String hex, float alpha) {
        int padding = hex.startsWith("#") ? 1 : 0;
        float red = (float)Integer.parseInt(hex.substring(padding, 2 + padding), 16) / 255.0f;
        float green = (float)Integer.parseInt(hex.substring(2 + padding, 4 + padding), 16) / 255.0f;
        float blue = (float)Integer.parseInt(hex.substring(4 + padding, 6 + padding), 16) / 255.0f;
        return Color.create(red, green, blue, alpha);
    }

    public static Color createWithFullAlpha(int hex) {
        return Color.createWithAlpha(hex, 255);
    }

    public static Color createWithAlpha(int hex, int alpha) {
        return Color.create(hex + (alpha << 24));
    }

    public static Color create(int hex) {
        int[] components4i = MathUtil.getColor4i(hex);
        return new Color(MathUtil.getColor4f(components4i), components4i, hex);
    }

    public static Color create(int red, int green, int blue) {
        return Color.create(red, green, blue, 255);
    }

    public static Color create(int red, int green, int blue, int alpha) {
        return Color.create(new int[]{red, green, blue, alpha});
    }

    public static Color create(int[] components) {
        Preconditions.checkArgument((components.length == 4 ? 1 : 0) != 0, (Object)"components must have length of 4");
        return new Color(MathUtil.getColor4f(components), components, MathUtil.getColorHex(components));
    }

    public static Color create(float red, float green, float blue) {
        return Color.create(red, green, blue, 1.0f);
    }

    public static Color create(float red, float green, float blue, float alpha) {
        return Color.create(new float[]{red, green, blue, alpha});
    }

    public static Color create(float[] components) {
        Preconditions.checkArgument((components.length == 4 ? 1 : 0) != 0, (Object)"components must have length of 4");
        int[] color4i = MathUtil.getColor4i(components);
        return new Color(components, color4i, MathUtil.getColorHex(color4i));
    }

    public int red() {
        return this.components4i[0];
    }

    public int green() {
        return this.components4i[1];
    }

    public int blue() {
        return this.components4i[2];
    }

    public int alpha() {
        return this.components4i[3];
    }

    public float[] components4f() {
        float[] result = new float[4];
        System.arraycopy(this.components4f, 0, result, 0, 4);
        return result;
    }

    public int[] components4i() {
        int[] result = new int[4];
        System.arraycopy(this.components4i, 0, result, 0, 4);
        return result;
    }

    public int multiplied(float alpha) {
        return MathUtil.multiplyAlpha(this.hex, alpha);
    }

    public boolean transparent() {
        return this.alpha() == 0;
    }

    @Override
    public String toString() {
        return "Color[rgba" + Arrays.toString(this.components4i) + " / #" + Integer.toHexString(this.hex) + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Color)) return false;
        Color other = (Color)obj;
        if (other.hex != this.hex) return false;
        return true;
    }

    @Nullable
    public static Color getFormattingColor(int code) {
        if (code >= 0 && code <= 15) {
            return VANILLA_COLORS[code];
        }
        return null;
    }

    static {
        KnownEvaluators.getInstance().register((Evaluator)new Evaluator<Color>(){

            public Color evaluate(Color v0, Color v1, double fraction) {
                return Color.create(MathUtil.lerp((float)fraction, v0.components4f(), v1.components4f()));
            }

            public Class<Color> getEvaluatorClass() {
                return Color.class;
            }
        });
        TRANSPARENT = Color.create(0, 0, 0, 0);
        BLACK = Color.create(0, 0, 0);
        DARK_BLUE = Color.create(0, 0, 170);
        DARK_GREEN = Color.create(0, 170, 0);
        DARK_AQUA = Color.create(0, 170, 170);
        DARK_RED = Color.create(170, 0, 0);
        DARK_PURPLE = Color.create(170, 0, 170);
        GOLD = Color.create(255, 170, 0);
        GRAY = Color.create(170, 170, 170);
        DARK_GRAY = Color.create(85, 85, 85);
        BLUE = Color.create(85, 85, 255);
        GREEN = Color.create(85, 255, 85);
        AQUA = Color.create(85, 255, 255);
        RED = Color.create(255, 85, 85);
        LIGHT_PURPLE = Color.create(255, 85, 255);
        YELLOW = Color.create(255, 255, 85);
        WHITE = Color.create(255, 255, 255);
        BLUE_C = Color.create(170, 220, 240);
        GRAY_224 = Color.create(224, 224, 224);
        VANILLA_COLORS = new Color[]{BLACK, DARK_BLUE, DARK_GREEN, DARK_AQUA, DARK_RED, DARK_PURPLE, GOLD, GRAY, DARK_GRAY, BLUE, GREEN, AQUA, RED, LIGHT_PURPLE, YELLOW, WHITE};
    }
}

