/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import flare.eventbus.EventBus;
import io.github.humbleui.skija.Canvas;
import io.github.humbleui.skija.ClipMode;
import io.github.humbleui.skija.FilterBlurMode;
import io.github.humbleui.skija.Image;
import io.github.humbleui.skija.MaskFilter;
import io.github.humbleui.skija.Paint;
import io.github.humbleui.skija.PaintMode;
import io.github.humbleui.types.IRect;
import io.github.humbleui.types.Point;
import io.github.humbleui.types.RRect;
import io.github.humbleui.types.Rect;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.Interpolator;
import org.jdesktop.core.animation.timing.PropertySetter;
import org.jdesktop.core.animation.timing.TimingTarget;
import org.jdesktop.core.animation.timing.interpolators.SplineInterpolator;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Bliss;
import sm0keysa1m0n.bliss.BoxShadow;
import sm0keysa1m0n.bliss.BoxSide;
import sm0keysa1m0n.bliss.BoxSizing;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.Filter;
import sm0keysa1m0n.bliss.Length;
import sm0keysa1m0n.bliss.Overflow;
import sm0keysa1m0n.bliss.PointerEvents;
import sm0keysa1m0n.bliss.Visibility;
import sm0keysa1m0n.bliss.layout.Layout;
import sm0keysa1m0n.bliss.layout.PositionType;
import sm0keysa1m0n.bliss.platform.GraphicsContext;
import sm0keysa1m0n.bliss.platform.ScissorStack;
import sm0keysa1m0n.bliss.style.Percentage;
import sm0keysa1m0n.bliss.style.States;
import sm0keysa1m0n.bliss.style.StyleList;
import sm0keysa1m0n.bliss.style.StyleManager;
import sm0keysa1m0n.bliss.style.StyleNode;
import sm0keysa1m0n.bliss.util.MathUtil;
import sm0keysa1m0n.bliss.view.GeometryUtil;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.ViewScreen;
import sm0keysa1m0n.bliss.view.ViewStyle;
import sm0keysa1m0n.bliss.view.event.ActionEvent;
import sm0keysa1m0n.bliss.view.event.AddedEvent;
import sm0keysa1m0n.bliss.view.event.CharTypeEvent;
import sm0keysa1m0n.bliss.view.event.KeyEvent;
import sm0keysa1m0n.bliss.view.event.MouseEnterEvent;
import sm0keysa1m0n.bliss.view.event.MouseEvent;
import sm0keysa1m0n.bliss.view.event.MouseLeaveEvent;
import sm0keysa1m0n.bliss.view.event.RemovedEvent;
import sm0keysa1m0n.bliss.view.event.ViewEvent;

public class View
implements Comparable<View>,
StyleNode {
    public static final boolean DEBUG = false;
    private static final int SCROLLBAR_WIDTH = 4;
    private static final float SCROLL_CHUNK = 50.0f;
    private static final float SCROLL_MOMENTUM_DAMPING = 3.0f;
    private static final int DOUBLE_CLICK_DURATION_MS = 500;
    protected final GraphicsContext graphicsContext = Bliss.instance().getGraphicsContext();
    private final EventBus<ViewEvent> eventBus = EventBus.create(ViewEvent.class, (boolean)false);
    private final ViewStyle style;
    @Nullable
    ViewScreen screen;
    @Nullable
    ParentView parent;
    int index;
    private Layout layout = Layout.NILL;
    private float lastScrollOffset;
    private float scrollOffset;
    private float scrollVelocity;
    private float fullHeight;
    private long lastClickTimeMs;
    private boolean closed;
    private boolean added;
    @Nullable
    private final String id;
    private final Set<String> styleClasses;
    private final boolean doubleClick;
    private final boolean unscaleWidth;
    private final boolean unscaleHeight;
    private final boolean unscaleBorder;
    private final boolean unscaleOutline;
    private final boolean focusable;

    public View(Properties properties) {
        this.id = properties.id;
        this.styleClasses = properties.styleClasses.build();
        this.doubleClick = properties.doubleClick;
        this.unscaleWidth = properties.unscaleWidth;
        this.unscaleHeight = properties.unscaleHeight;
        this.unscaleBorder = properties.unscaleBorder;
        this.unscaleOutline = properties.unscaleOutline;
        this.focusable = properties.focusable;
        this.style = new ViewStyle(this);
        this.getStyleManager().addState(States.ENABLED);
    }

    public EventBus<ViewEvent> eventBus() {
        return this.eventBus;
    }

    protected float computeFullHeight() {
        return this.getContentHeight();
    }

    protected void added() {
        this.style.getStyleManager().refresh();
        this.added = true;
        this.eventBus.publish((Object)new AddedEvent());
    }

    protected void removed() {
        this.added = false;
        this.eventBus.publish((Object)new RemovedEvent());
    }

    protected void setLayout(Layout layout) {
        Objects.requireNonNull(layout, "layout cannot be null.");
        if (this.layout == layout) {
            return;
        }
        this.layout.close();
        this.layout = layout;
        this.layout.setAll(this.getStyle());
    }

    protected void layout() {
        this.fullHeight = this.computeFullHeight();
        this.scrollOffset = this.clampScrollOffset(this.scrollOffset);
    }

    public void tick() {
        this.lastScrollOffset = this.scrollOffset;
        this.scrollVelocity *= 0.33333334f;
        if (Math.abs(this.scrollVelocity) < 0.08f) {
            this.scrollVelocity = 0.0f;
        }
        this.scrollOffset += this.scrollVelocity;
        if (this.scrollOffset < 0.0f || this.scrollOffset > this.fullHeight - this.getContentHeight()) {
            this.scrollVelocity = 0.0f;
        }
        this.scrollOffset = this.clampScrollOffset(this.scrollOffset);
    }

    public final void render(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        Canvas canvas = this.graphicsContext.canvas();
        canvas.save();
        boolean clip = this.layout.getOverflow().isClipped();
        this.drawAndClipBox(canvas, clip);
        if (clip) {
            float scale = this.graphicsContext.scale();
            ScissorStack.push((int)(this.getScaledX() * scale), (int)((float)this.graphicsContext.height() - (this.getScaledY() * scale + this.getScaledHeight() * scale)), (int)(this.getScaledWidth() * scale), (int)(this.getScaledHeight() * scale));
        }
        this.renderContent(mouseX, mouseY);
        if (clip) {
            ScissorStack.pop();
        }
        this.drawScrollbar();
        canvas.restore();
    }

    private void drawScrollbar() {
        if (!this.isScrollbarEnabled()) {
            return;
        }
        float scale = this.graphicsContext.scale();
        float scrollbarX = this.getScrollbarX();
        float scaledY = this.getScaledY();
        float scrollbarWidth = 4.0f * this.getXScale();
        float scrollbarRadius = scrollbarWidth / 2.0f * scale;
        float scrollbarX2 = scrollbarX + scrollbarWidth;
        float scaledY2 = scaledY + this.getScaledHeight();
        Canvas canvas = this.graphicsContext.canvas();
        try (Paint paint = new Paint();){
            paint.setMode(PaintMode.FILL);
            paint.setColor(0x40000000);
            canvas.drawRRect(RRect.makeLTRB((float)(scrollbarX * scale), (float)(scaledY * scale), (float)(scrollbarX2 * scale), (float)(scaledY2 * scale), (float)scrollbarRadius), paint);
        }
        float scrollbarY = this.getScrollbarY();
        float scrollbarY2 = scrollbarY + this.getScrollbarHeight();
        try (Paint paint = new Paint();){
            paint.setMode(PaintMode.FILL);
            paint.setColor(0x4CFFFFFF);
            canvas.drawRRect(RRect.makeLTRB((float)(scrollbarX * scale), (float)(scrollbarY * scale), (float)(scrollbarX2 * scale), (float)(scrollbarY2 * scale), (float)scrollbarRadius), paint);
        }
    }

    private void drawAndClipBox(Canvas canvas, boolean clip) {
        float scale = this.graphicsContext.scale();
        float topBorderWidth = this.unscale(this.layout.getTopBorder(), this.unscaleBorder);
        float bottomBorderWidth = this.unscale(this.layout.getBottomBorder(), this.unscaleBorder);
        float leftBorderWidth = this.unscale(this.layout.getLeftBorder(), this.unscaleBorder);
        float rightBorderWidth = this.unscale(this.layout.getRightBorder(), this.unscaleBorder);
        float borderTopLeftRadius = this.unscale(((Float)this.style.borderTopLeftRadius.get()).floatValue(), this.unscaleBorder);
        float borderTopRightRadius = this.unscale(((Float)this.style.borderTopRightRadius.get()).floatValue(), this.unscaleBorder);
        float borderBottomRightRadius = this.unscale(((Float)this.style.borderBottomRightRadius.get()).floatValue(), this.unscaleBorder);
        float borderBottomLeftRadius = this.unscale(((Float)this.style.borderBottomLeftRadius.get()).floatValue(), this.unscaleBorder);
        float outlineWidth = this.unscale(((Length)this.style.outlineWidth.get()).fixed(), this.unscaleOutline);
        float[] radii = new float[]{borderTopLeftRadius * scale, borderTopRightRadius * scale, borderBottomRightRadius * scale, borderBottomLeftRadius * scale};
        RRect rect = RRect.makeComplexXYWH((float)(this.getScaledX() * scale), (float)(this.getScaledY() * scale), (float)(this.getScaledWidth() * scale), (float)(this.getScaledHeight() * scale), (float[])radii);
        this.drawBackdrop(canvas, rect);
        if (clip) {
            canvas.clipRRect(rect, true);
        }
        RRect innerRect = RRect.makeComplexLTRB((float)(rect.getLeft() + leftBorderWidth * scale), (float)(rect.getTop() + topBorderWidth * scale), (float)(rect.getRight() - rightBorderWidth * scale), (float)(rect.getBottom() - bottomBorderWidth * scale), (float[])radii);
        try (Paint paint = new Paint();){
            if (topBorderWidth > 0.0f) {
                paint.setColor(((Color)this.style.borderTopColor.get()).multiplied(this.getAlpha()));
                this.drawBorderEdge(canvas, rect, innerRect, BoxSide.TOP, paint);
            }
            if (rightBorderWidth > 0.0f) {
                paint.setColor(((Color)this.style.borderRightColor.get()).multiplied(this.getAlpha()));
                this.drawBorderEdge(canvas, rect, innerRect, BoxSide.RIGHT, paint);
            }
            if (bottomBorderWidth > 0.0f) {
                paint.setColor(((Color)this.style.borderBottomColor.get()).multiplied(this.getAlpha()));
                this.drawBorderEdge(canvas, rect, innerRect, BoxSide.BOTTOM, paint);
            }
            if (leftBorderWidth > 0.0f) {
                paint.setColor(((Color)this.style.borderLeftColor.get()).multiplied(this.getAlpha()));
                this.drawBorderEdge(canvas, rect, innerRect, BoxSide.LEFT, paint);
            }
        }
        paint = new Paint();
        try {
            paint.setMode(PaintMode.FILL);
            paint.setColor(((Color)this.style.backgroundColor.get()).multiplied(this.getAlpha()));
            canvas.drawRRect(rect, paint);
        }
        finally {
            paint.close();
        }
        if (clip) {
            this.drawBoxShadows(canvas, rect, true);
        } else {
            canvas.save();
            canvas.clipRRect(rect, true);
            this.drawBoxShadows(canvas, rect, true);
            canvas.restore();
        }
        if (outlineWidth > 0.0f) {
            paint = new Paint();
            try {
                paint.setMode(PaintMode.STROKE);
                paint.setStrokeWidth(outlineWidth * scale);
                paint.setColor(((Color)this.style.outlineColor.get()).multiplied(this.getAlpha()));
                paint.setAntiAlias(false);
                canvas.drawRRect(rect.inflate(outlineWidth).withRadii(radii), paint);
            }
            finally {
                paint.close();
            }
        }
    }

    private static RRect inflate(RRect rect, float spreadX, float spreadY) {
        float midSpread = (spreadX + spreadY) / 2.0f;
        float[] radii = Arrays.copyOf(rect._radii, rect._radii.length);
        for (int i = 0; i < radii.length; ++i) {
            radii[i] = Math.max(0.0f, radii[i] + midSpread);
        }
        return new RRect(rect._left - spreadX, rect._top - spreadY, Math.max(rect._left - spreadX, rect._right + spreadX), Math.max(rect._top - spreadY, rect._bottom + spreadY), radii);
    }

    private void drawBoxShadows(Canvas canvas, RRect rect, boolean inset) {
        BoxShadow[] shadows;
        for (BoxShadow shadow : shadows = (BoxShadow[])this.style.boxShadow.get()) {
            try (Paint paint = new Paint();){
                paint.setColor(shadow.color().multiplied(this.getAlpha()));
                if (shadow.blurRadius() > 0.0f) {
                    paint.setMaskFilter(MaskFilter.makeBlur((FilterBlurMode)FilterBlurMode.NORMAL, (float)shadow.blurRadius()));
                }
                if (shadow.inset() && inset) {
                    Point delta = new Point(10.0f + Math.abs(shadow.offsetX()), 10.0f + Math.abs(shadow.offsetY()));
                    RRect inner = View.inflate(rect, -shadow.spreadRadius(), -shadow.spreadRadius()).offset(shadow.offsetX(), shadow.offsetY());
                    RRect outer = View.inflate(rect, delta.getX(), delta.getY());
                    canvas.drawDRRect(outer, inner, paint);
                    continue;
                }
                if (shadow.inset() || inset) continue;
                canvas.drawRRect(View.inflate(rect, shadow.spreadRadius(), shadow.spreadRadius()).offset(shadow.offsetX(), shadow.offsetY()), paint);
            }
        }
    }

    private void drawBackdrop(Canvas canvas, RRect rect) {
        block13: {
            Filter[] backdropFilters = (Filter[])this.style.backdropFilter.get();
            if (backdropFilters.length == 0) {
                this.drawBoxShadows(canvas, rect, false);
                return;
            }
            IRect intRect = rect.toIRect();
            try (Image image = this.graphicsContext.surface().makeImageSnapshot(intRect);){
                if (image == null) break block13;
                try (Paint paint = new Paint();){
                    for (Filter filter : backdropFilters) {
                        filter.apply(paint);
                    }
                    canvas.save();
                    canvas.clipRRect(rect, ClipMode.DIFFERENCE);
                    this.drawBoxShadows(canvas, rect, false);
                    canvas.restore();
                    canvas.save();
                    canvas.clipRRect(rect, true);
                    canvas.drawImageRect(image, intRect.toRect(), paint);
                    canvas.restore();
                }
            }
        }
    }

    private void drawBorderEdge(Canvas canvas, RRect rect, RRect innerRect, BoxSide side, Paint paint) {
        canvas.save();
        this.clipBorderSidePolygon(canvas, rect, innerRect, side, false, false);
        canvas.drawDRRect(rect, innerRect, paint);
        canvas.restore();
    }

    private void clipBorderSidePolygon(Canvas canvas, RRect outerRect, RRect innerRect, BoxSide side, boolean firstEdgeMatches, boolean secondEdgeMatches) {
        Point[] finalQuad = switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case BoxSide.TOP -> {
                Point[] quad = new Point[]{GeometryUtil.getTopLeft((Rect)outerRect), GeometryUtil.getTopLeft((Rect)innerRect), GeometryUtil.getTopRight((Rect)innerRect), GeometryUtil.getTopRight((Rect)outerRect)};
                if (innerRect._radii[0] != 0.0f) {
                    GeometryUtil.findIntersection(GeometryUtil.getTopLeft((Rect)outerRect), GeometryUtil.getTopLeft((Rect)innerRect), GeometryUtil.getBottomLeft((Rect)innerRect), GeometryUtil.getTopRight((Rect)innerRect)).ifPresent(point -> {
                        quad[1] = point;
                    });
                }
                if (innerRect._radii[1] != 0.0f) {
                    GeometryUtil.findIntersection(GeometryUtil.getTopRight((Rect)outerRect), GeometryUtil.getTopRight((Rect)innerRect), GeometryUtil.getTopLeft((Rect)innerRect), GeometryUtil.getBottomRight((Rect)innerRect)).ifPresent(point -> {
                        quad[2] = point;
                    });
                }
                yield quad;
            }
            case BoxSide.LEFT -> {
                Point[] quad = new Point[]{GeometryUtil.getTopLeft((Rect)outerRect), GeometryUtil.getTopLeft((Rect)innerRect), GeometryUtil.getBottomLeft((Rect)innerRect), GeometryUtil.getBottomLeft((Rect)outerRect)};
                if (innerRect._radii[0] != 0.0f) {
                    GeometryUtil.findIntersection(GeometryUtil.getTopLeft((Rect)outerRect), GeometryUtil.getTopLeft((Rect)innerRect), GeometryUtil.getBottomLeft((Rect)innerRect), GeometryUtil.getTopRight((Rect)innerRect)).ifPresent(point -> {
                        quad[1] = point;
                    });
                }
                if (innerRect._radii[3] != 0.0f) {
                    GeometryUtil.findIntersection(GeometryUtil.getBottomLeft((Rect)outerRect), GeometryUtil.getBottomLeft((Rect)innerRect), GeometryUtil.getTopLeft((Rect)innerRect), GeometryUtil.getBottomRight((Rect)innerRect)).ifPresent(point -> {
                        quad[2] = point;
                    });
                }
                yield quad;
            }
            case BoxSide.BOTTOM -> {
                Point[] quad = new Point[]{GeometryUtil.getBottomLeft((Rect)outerRect), GeometryUtil.getBottomLeft((Rect)innerRect), GeometryUtil.getBottomRight((Rect)innerRect), GeometryUtil.getBottomRight((Rect)outerRect)};
                if (innerRect._radii[3] != 0.0f) {
                    GeometryUtil.findIntersection(GeometryUtil.getBottomLeft((Rect)outerRect), GeometryUtil.getBottomLeft((Rect)innerRect), GeometryUtil.getTopLeft((Rect)innerRect), GeometryUtil.getBottomRight((Rect)innerRect)).ifPresent(point -> {
                        quad[1] = point;
                    });
                }
                if (innerRect._radii[2] != 0.0f) {
                    GeometryUtil.findIntersection(GeometryUtil.getBottomRight((Rect)outerRect), GeometryUtil.getBottomRight((Rect)innerRect), GeometryUtil.getTopRight((Rect)innerRect), GeometryUtil.getBottomLeft((Rect)innerRect)).ifPresent(point -> {
                        quad[2] = point;
                    });
                }
                yield quad;
            }
            case BoxSide.RIGHT -> {
                Point[] quad = new Point[]{GeometryUtil.getTopRight((Rect)outerRect), GeometryUtil.getTopRight((Rect)innerRect), GeometryUtil.getBottomRight((Rect)innerRect), GeometryUtil.getBottomRight((Rect)outerRect)};
                if (innerRect._radii[1] != 0.0f) {
                    GeometryUtil.findIntersection(GeometryUtil.getTopRight((Rect)outerRect), GeometryUtil.getTopRight((Rect)innerRect), GeometryUtil.getTopLeft((Rect)innerRect), GeometryUtil.getBottomRight((Rect)innerRect)).ifPresent(point -> {
                        quad[1] = point;
                    });
                }
                if (innerRect._radii[2] != 0.0f) {
                    GeometryUtil.findIntersection(GeometryUtil.getBottomRight((Rect)outerRect), GeometryUtil.getBottomRight((Rect)innerRect), GeometryUtil.getTopRight((Rect)innerRect), GeometryUtil.getBottomLeft((Rect)innerRect)).ifPresent(point -> {
                        quad[2] = point;
                    });
                }
                yield quad;
            }
        };
        if (firstEdgeMatches == secondEdgeMatches) {
            canvas.clipPath(GeometryUtil.polygonPathFromPoints(finalQuad), ClipMode.INTERSECT, !firstEdgeMatches);
            return;
        }
        Point[] firstQuad = new Point[]{finalQuad[0], finalQuad[1], finalQuad[2], side == BoxSide.TOP || side == BoxSide.BOTTOM ? new Point(finalQuad[3].getX(), finalQuad[2].getY()) : new Point(finalQuad[2].getX(), finalQuad[3].getY()), finalQuad[3]};
        canvas.clipPath(GeometryUtil.polygonPathFromPoints(firstQuad), ClipMode.INTERSECT, !firstEdgeMatches);
        Point[] secondQuad = new Point[]{finalQuad[0], side == BoxSide.TOP || side == BoxSide.BOTTOM ? new Point(finalQuad[0].getX(), finalQuad[1].getY()) : new Point(finalQuad[1].getX(), finalQuad[0].getY()), finalQuad[1], finalQuad[2], finalQuad[3]};
        canvas.clipPath(GeometryUtil.polygonPathFromPoints(secondQuad), ClipMode.INTERSECT, false);
    }

    protected final boolean isScrollbarEnabled() {
        return this.layout.getOverflow() == Overflow.SCROLL && this.fullHeight > this.getContentHeight();
    }

    protected void renderContent(int mouseX, int mouseY) {
    }

    private final float getScrollbarX() {
        return this.getScaledX() + this.getScaledWidth() - 4.0f * this.getXScale();
    }

    private final float getScrollbarY() {
        return this.getScaledY() + this.getScrollOffset(this.graphicsContext.frameTime()) / this.fullHeight * this.getScaledHeight();
    }

    private final float getScrollOffset(float partialTicks) {
        return MathUtil.lerp(partialTicks, this.lastScrollOffset, this.scrollOffset);
    }

    @VisibleForTesting
    public final float getScrollOffset() {
        return this.scrollOffset;
    }

    @VisibleForTesting
    public final void setScrollOffset(float scrollOffset) {
        this.scrollOffset = scrollOffset;
    }

    private final float getScrollbarHeight() {
        return MathUtil.clamp(this.getScaledHeight() * (this.getContentHeight() / this.fullHeight), 10.0f * this.getYScale(), this.getScaledHeight());
    }

    private final void scrollTo(float y, long durationMs) {
        new Animator.Builder().addTarget((TimingTarget)PropertySetter.getTargetTo((Object)this, (String)"scrollOffset", (Interpolator)new SplineInterpolator(0.25, 0.1, 0.25, 1.0), (Object[])new Float[]{Float.valueOf(this.clampScrollOffset(y))})).setDuration(durationMs, TimeUnit.MILLISECONDS).build().start();
    }

    private final float clampScrollOffset(float scrollOffset) {
        return MathUtil.clamp(scrollOffset, 0.0f, this.fullHeight - this.getContentHeight());
    }

    public void mouseEntered(double mouseX, double mouseY) {
        this.getStyleManager().addState(States.HOVER);
        this.getStyleManager().notifyListeners();
        this.eventBus.publish((Object)new MouseEnterEvent());
    }

    public void mouseLeft(double mouseX, double mouseY) {
        this.getStyleManager().removeState(States.HOVER);
        this.getStyleManager().notifyListeners();
        this.eventBus.publish((Object)new MouseLeaveEvent());
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.eventBus.publish((Object)new MouseEvent.MoveEvent(mouseX, mouseY));
    }

    public boolean tryFocus(boolean visible) {
        if (this.isFocused()) {
            return true;
        }
        if (!this.focusable || this.getStyleManager().hasState(States.DISABLED)) {
            return false;
        }
        if (visible) {
            this.getStyleManager().addState(States.FOCUS_VISIBLE);
        }
        this.getStyleManager().addState(States.FOCUS);
        this.getStyleManager().notifyListeners();
        this.focusChanged();
        if (this.parent != null) {
            this.parent.focusedView = this;
        }
        return true;
    }

    public void removeFocus() {
        if (this.isFocused()) {
            this.getStyleManager().removeState(States.FOCUS);
            this.getStyleManager().removeState(States.FOCUS_VISIBLE);
            this.getStyleManager().notifyListeners();
            this.focusChanged();
            if (this.parent != null) {
                this.parent.focusedView = null;
            }
        }
    }

    public boolean mousePressed(double mouseX, double mouseY, int button) {
        if (this.eventBus.publishCancellable((Object)new MouseEvent.ButtonEvent(mouseX, mouseY, button, 1))) {
            return false;
        }
        if (this.isScrollbarEnabled() && button == 0 && mouseX >= (double)(this.getScaledX() + this.getScaledWidth() - 4.0f) && mouseX <= (double)(this.getScaledX() + this.getScaledWidth()) && mouseY >= (double)this.getScaledY() && mouseY <= (double)(this.getScaledY() + this.getScaledHeight())) {
            if (mouseY < (double)this.getScrollbarY() || mouseY > (double)(this.getScrollbarY() + this.getScrollbarHeight())) {
                this.scrollTo(this.scrollOffset + (mouseY > (double)this.getScrollbarY() ? this.getScaledHeight() : -this.getScaledHeight()), 200L);
            }
            return true;
        }
        if (!this.isFocused()) {
            return false;
        }
        long currentTime = Bliss.instance().platform().milliTime();
        long deltaTime = currentTime - this.lastClickTimeMs;
        this.lastClickTimeMs = currentTime;
        if (!this.doubleClick || deltaTime < 500L) {
            this.eventBus.publish((Object)new ActionEvent());
        }
        return false;
    }

    public void mouseReleased(double mouseX, double mouseY, int button) {
        this.eventBus.publish((Object)new MouseEvent.ButtonEvent(mouseX, mouseY, button, 0));
    }

    public void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.isScrollbarEnabled() && mouseY >= (double)this.getScaledY() && mouseY <= (double)(this.getScaledY() + this.getScaledHeight())) {
            this.scrollOffset = this.clampScrollOffset(this.scrollOffset + (float)deltaY * this.fullHeight / this.getScaledHeight());
            return;
        }
        this.eventBus.publish((Object)new MouseEvent.DragEvent(mouseX, mouseY, button, deltaX, deltaY));
    }

    public void mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        if (this.isScrollbarEnabled()) {
            this.scrollVelocity += (float)(-scrollDelta * 50.0);
        }
        this.eventBus.publish((Object)new MouseEvent.ScrollEvent(mouseX, mouseY, scrollDelta));
    }

    public void keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.eventBus.publishCancellable((Object)new KeyEvent(keyCode, scanCode, 1, modifiers))) {
            return;
        }
        if (keyCode == 257 && this.eventBus.publishCancellable((Object)new ActionEvent())) {
            return;
        }
    }

    public void keyReleased(int keyCode, int scanCode, int modifiers) {
        this.eventBus.publish((Object)new KeyEvent(keyCode, scanCode, 0, modifiers));
    }

    public void charTyped(char codePoint, int modifiers) {
        this.eventBus.publish((Object)new CharTypeEvent(codePoint, modifiers));
    }

    public Optional<View> changeFocus(boolean forward) {
        if (!this.focusable || this.getStyleManager().hasState(States.DISABLED)) {
            return Optional.empty();
        }
        boolean focused = this.getStyleManager().toggleState(States.FOCUS);
        if (focused) {
            this.getStyleManager().addState(States.FOCUS_VISIBLE);
        } else {
            this.getStyleManager().removeState(States.FOCUS_VISIBLE);
        }
        this.getStyleManager().notifyListeners();
        this.focusChanged();
        return focused ? Optional.of(this) : Optional.empty();
    }

    protected void focusChanged() {
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.style.pointerEvents.get() != PointerEvents.NONE && mouseX > (double)this.getScaledX() && mouseX < (double)(this.getScaledX() + this.getScaledWidth()) && mouseY > (double)this.getScaledY() && mouseY < (double)(this.getScaledY() + this.getScaledHeight());
    }

    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        this.layout.close();
        this.closed = true;
    }

    public final float getScaledContentX() {
        return this.getContentX() + (this.getContentWidth() - this.getContentWidth() * ((Float)this.style.xScale.get()).floatValue()) / 2.0f + (this.layout.getLeftPadding() - this.layout.getLeftPadding() * ((Float)this.style.xScale.get()).floatValue()) / 2.0f + (this.layout.getRightPadding() - this.layout.getRightPadding() * ((Float)this.style.xScale.get()).floatValue()) / 2.0f + (this.isScrollbarEnabled() ? (4.0f - 4.0f * ((Float)this.style.xScale.get()).floatValue()) / 2.0f : 0.0f);
    }

    public float getContentX() {
        return this.getX() + this.layout.getLeftPadding() * this.getXScale() + this.unscale(this.layout.getLeftBorder(), this.unscaleBorder) * this.getXScale();
    }

    public final float getScaledX() {
        return this.getX() + (this.getWidth() - this.getWidth() * ((Float)this.style.xScale.get()).floatValue()) / 2.0f;
    }

    public final float getX() {
        float parentWidth;
        float x;
        PositionType position = (PositionType)((Object)this.style.position.get());
        float f = x = this.parent == null ? 0.0f : this.parent.getScaledContentX();
        if (position != PositionType.ABSOLUTE) {
            float layoutX = this.layout.getX();
            x += layoutX + layoutX * this.getXScale() - layoutX * ((Float)this.style.xScale.get()).floatValue();
        }
        Length left = (Length)this.style.left.get();
        Length right = (Length)this.style.right.get();
        float f2 = parentWidth = this.parent == null ? (float)this.screen.width() : this.parent.getScaledWidth();
        if (left != Length.AUTO) {
            x += left.valueForLength(parentWidth);
        } else if (right != Length.AUTO) {
            if (position == PositionType.ABSOLUTE) {
                float parentRight = this.parent == null ? (float)this.screen.width() : this.parent.getScaledContentX() + this.parent.getScaledContentWidth();
                x = parentRight - right.valueForLength(parentWidth) - this.getScaledWidth();
            } else {
                x -= right.valueForLength(parentWidth);
            }
        }
        return x + ((Float)this.style.xTranslation.get()).floatValue() + this.unscaleOffset(this.getWidth(), this.unscaleWidth);
    }

    public final float getScaledContentY() {
        return this.getContentY() + (this.getContentHeight() - this.getContentHeight() * ((Float)this.style.yScale.get()).floatValue()) / 2.0f + (this.layout.getTopPadding() - this.layout.getTopPadding() * ((Float)this.style.yScale.get()).floatValue()) / 2.0f + (this.layout.getBottomPadding() - this.layout.getBottomPadding() * ((Float)this.style.yScale.get()).floatValue()) / 2.0f;
    }

    public float getContentY() {
        return this.getY() + this.layout.getTopPadding() * this.getYScale() + this.unscale(this.layout.getTopBorder(), this.unscaleBorder) * this.getYScale() - (this.isScrollbarEnabled() ? this.getScrollOffset(this.graphicsContext.frameTime()) * this.getYScale() : 0.0f);
    }

    public final float getScaledY() {
        return this.getY() + (this.getHeight() - this.getHeight() * ((Float)this.style.yScale.get()).floatValue()) / 2.0f;
    }

    public final float getY() {
        float parentHeight;
        float y;
        PositionType position = (PositionType)((Object)this.style.position.get());
        float f = y = this.parent == null ? 0.0f : this.parent.getScaledContentY();
        if (position != PositionType.ABSOLUTE) {
            float layoutY = this.layout.getY();
            y += layoutY + layoutY * this.getYScale() - layoutY * ((Float)this.style.yScale.get()).floatValue();
        }
        Length top = (Length)this.style.top.get();
        Length bottom = (Length)this.style.bottom.get();
        float f2 = parentHeight = this.parent == null ? (float)this.screen.height() : this.parent.getScaledHeight();
        if (top != Length.AUTO) {
            y += top.valueForLength(parentHeight);
        } else if (bottom != Length.AUTO) {
            if (position == PositionType.ABSOLUTE) {
                float parentRight = this.parent == null ? (float)this.screen.height() : this.parent.getScaledContentY() + this.parent.getScaledContentHeight();
                y = parentRight - bottom.valueForLength(parentHeight) - this.getScaledHeight();
            } else {
                y -= bottom.valueForLength(parentHeight);
            }
        }
        return y + ((Float)this.style.yTranslation.get()).floatValue() + (this.unscaleHeight ? this.getHeight() * this.graphicsContext.scale() - this.getHeight() : 0.0f);
    }

    public final float getScaledContentWidth() {
        return this.getContentWidth() * this.getXScale();
    }

    public float getContentWidth() {
        return this.getWidth() - (this.isScrollbarEnabled() ? 4.0f : 0.0f) - this.layout.getRightPadding() - this.layout.getLeftPadding() - this.unscale(this.layout.getRightBorder(), this.unscaleBorder) - this.unscale(this.layout.getLeftBorder(), this.unscaleBorder);
    }

    public final float getScaledWidth() {
        return this.getWidth() * this.getXScale();
    }

    public final float getWidth() {
        float width = this.unscale(this.layout.getWidth(), this.unscaleWidth);
        Length right = (Length)this.style.right.get();
        if (right != Length.AUTO && this.style.position.get() == PositionType.ABSOLUTE && width == 0.0f) {
            float parentWidth = this.parent == null ? (float)this.screen.width() : this.parent.getWidth();
            float parentRight = this.parent == null ? parentWidth : this.parent.getX() + parentWidth;
            width = parentRight - right.valueForLength(parentWidth) - this.getX();
        }
        if (this.style.boxSizing.get() == BoxSizing.CONTENT_BOX) {
            width += this.layout.getRightPadding() + this.layout.getLeftPadding() + this.unscale(this.layout.getRightBorder(), this.unscaleBorder) + this.unscale(this.layout.getLeftBorder(), this.unscaleBorder);
        }
        return width;
    }

    public final float getScaledContentHeight() {
        return this.getContentHeight() * this.getYScale();
    }

    public final float getContentHeight() {
        return this.getHeight() - this.layout.getBottomPadding() - this.layout.getTopPadding() - this.unscale(this.layout.getBottomBorder(), this.unscaleBorder) - this.unscale(this.layout.getTopBorder(), this.unscaleBorder);
    }

    public float getScaledHeight() {
        return this.getHeight() * this.getYScale();
    }

    public final float getHeight() {
        float height = this.unscale(this.layout.getHeight(), this.unscaleHeight);
        Length bottom = (Length)this.style.bottom.get();
        if (bottom != Length.AUTO && this.style.position.get() == PositionType.ABSOLUTE && height == 0.0f) {
            float parentHeight = this.parent == null ? (float)this.screen.height() : this.parent.getHeight();
            float parentBottom = this.parent == null ? parentHeight : this.parent.getY() + parentHeight;
            height = parentBottom - bottom.valueForLength(parentHeight) - this.getY();
        }
        if (this.style.boxSizing.get() == BoxSizing.CONTENT_BOX) {
            height += this.layout.getBottomPadding() + this.layout.getTopPadding() + this.unscale(this.layout.getBottomBorder(), this.unscaleBorder) + this.unscale(this.layout.getTopBorder(), this.unscaleBorder);
        }
        return height;
    }

    public final float getXScale() {
        return (this.parent == null ? 1.0f : this.parent.getXScale()) * ((Float)this.style.xScale.get()).floatValue();
    }

    public final float getYScale() {
        return (this.parent == null ? 1.0f : this.parent.getYScale()) * ((Float)this.style.yScale.get()).floatValue();
    }

    public final float getAlpha() {
        return (this.parent == null ? 1.0f : this.parent.getAlpha()) * ((Percentage)this.style.opacity.get()).value();
    }

    public final void setEnabled(boolean enabled) {
        if (enabled) {
            this.getStyleManager().addState(States.ENABLED);
            this.getStyleManager().removeState(States.DISABLED);
        } else {
            this.getStyleManager().removeState(States.ENABLED);
            this.getStyleManager().addState(States.DISABLED);
            if (this.getStyleManager().hasState(States.FOCUS)) {
                this.getStyleManager().removeState(States.FOCUS);
            }
        }
        this.getStyleManager().notifyListeners();
    }

    public final boolean isHovered() {
        return this.getStyleManager().hasState(States.HOVER);
    }

    public final boolean isFocused() {
        return this.getStyleManager().hasState(States.FOCUS);
    }

    public final ViewScreen getScreen() {
        if (this.screen == null) {
            if (this.parent == null) {
                throw new UnsupportedOperationException("Root view has no screen.");
            }
            return this.parent.getScreen();
        }
        return this.screen;
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public final ParentView getParent() {
        return this.parent;
    }

    public final boolean hasLayout() {
        return this.layout != null;
    }

    public final Layout getLayout() {
        return this.layout;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final boolean isAdded() {
        return this.added;
    }

    protected final float unscaleOffset(float value, boolean condition) {
        return condition ? value * this.graphicsContext.scale() - value : 0.0f;
    }

    protected final float unscale(float value, boolean condition) {
        return condition ? value / this.graphicsContext.scale() : value;
    }

    public void traverseUpward(Consumer<View> handler) {
        this.traverseUpward(handler, true);
    }

    public void traverseUpward(Consumer<View> handler, boolean includeSelf) {
        View view;
        View view2 = view = includeSelf ? this : this.parent;
        while (view != null) {
            handler.accept(view);
            view = view.parent;
        }
    }

    public Optional<View> traverseUpwardUntil(Predicate<View> filter) {
        return this.traverseUpwardUntil(filter, true);
    }

    public Optional<View> traverseUpwardUntil(Predicate<View> filter, boolean includeSelf) {
        View view;
        View view2 = view = includeSelf ? this : this.parent;
        while (view != null) {
            if (filter.test(view)) {
                return Optional.of(view);
            }
            view = view.parent;
        }
        return Optional.empty();
    }

    @Override
    public final int compareTo(View o) {
        return Float.compare(this.index + (Integer)this.style.zIndex.get(), o.index + (Integer)o.style.zIndex.get());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<String> getStyleClasses() {
        return this.styleClasses;
    }

    @Override
    public final String getType() {
        if (this.getClass().isAnonymousClass()) {
            return this.getClass().getSuperclass().getSimpleName();
        }
        return this.getClass().getSimpleName();
    }

    @Override
    public StyleManager getStyleManager() {
        return this.style.getStyleManager();
    }

    @Override
    public boolean isVisible() {
        return this.added && this.style.visibility.get() == Visibility.VISIBLE;
    }

    @Override
    public StyleList getStyleList() {
        return this.getScreen().styleList();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void refreshStyle() {
        this.style.getStyleManager().refresh();
    }

    public ViewStyle getStyle() {
        return this.style;
    }

    public static final class Properties {
        @Nullable
        private String id;
        private final ImmutableSet.Builder<String> styleClasses = ImmutableSet.builder();
        private boolean doubleClick;
        private boolean unscaleWidth;
        private boolean unscaleHeight;
        private boolean unscaleBorder = true;
        private boolean unscaleOutline = true;
        private boolean focusable;

        public Properties id(String id) {
            this.id = id;
            return this;
        }

        public Properties styleClasses(String ... styleClasses) {
            this.styleClasses.add((Object[])styleClasses);
            return this;
        }

        public Properties styleClasses(Iterable<String> styleClasses) {
            this.styleClasses.addAll(styleClasses);
            return this;
        }

        public Properties doubleClick(boolean doubleClick) {
            this.doubleClick = doubleClick;
            return this;
        }

        public Properties unscaleWidth(boolean unscaleWidth) {
            this.unscaleWidth = unscaleWidth;
            return this;
        }

        public Properties unscaleHeight(boolean unscaleHeight) {
            this.unscaleHeight = unscaleHeight;
            return this;
        }

        public Properties unscaleBorder(boolean unscaleBorder) {
            this.unscaleBorder = unscaleBorder;
            return this;
        }

        public Properties unscaleOutline(boolean unscaleOutline) {
            this.unscaleOutline = unscaleOutline;
            return this;
        }

        public Properties focusable(boolean focusable) {
            this.focusable = focusable;
            return this;
        }
    }
}

