/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import io.github.humbleui.skija.Canvas;
import io.github.humbleui.skija.Paint;
import io.github.humbleui.skija.PaintMode;
import io.github.humbleui.types.Rect;
import java.util.function.Consumer;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.StyledText;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.event.ActionEvent;

public class TabsView
extends ParentView {
    private TabView selectedTab = null;

    public TabsView(View.Properties properties) {
        super(properties);
    }

    public TabsView addTab(Runnable selectedListener, StyledText text) {
        return this.addTab(selectedListener, text, __ -> {});
    }

    public TabsView addTab(Runnable selectedListener, StyledText text, Consumer<TabView> customizer) {
        TabView view = new TabView(selectedListener);
        view.addChild(new TextView(new View.Properties()).setText(text));
        view.eventBus().subscribe(ActionEvent.class, event -> this.selectTab(view));
        customizer.accept(view);
        this.addChild(view);
        return this;
    }

    @Override
    public void added() {
        super.added();
        if (this.getChildren().size() > 0) {
            this.selectTab((TabView)this.getChildren().get(0));
        }
    }

    private void selectTab(TabView newTab) {
        TabView previousTab = this.selectedTab;
        this.selectedTab = newTab;
        if (previousTab != newTab) {
            newTab.selectedListener.run();
        }
    }

    public class TabView
    extends ParentView {
        private static final float UNDERSCORE_HEIGHT = 2.5f;
        private static final float HOVERED_UNDERSCORE_HEIGHT = 1.6666666f;
        private static final Color underscoreColor = Color.WHITE;
        private final Runnable selectedListener;

        public TabView(Runnable selectedListener) {
            super(new View.Properties().focusable(true));
            this.selectedListener = selectedListener;
        }

        @Override
        public void renderContent(int mouseX, int mouseY) {
            super.renderContent(mouseX, mouseY);
            Canvas canvas = this.graphicsContext.canvas();
            float scale = this.graphicsContext.scale();
            if (TabsView.this.selectedTab == this) {
                try (Paint paint = new Paint();){
                    paint.setColor(underscoreColor.multiplied(this.getAlpha()));
                    paint.setMode(PaintMode.FILL);
                    canvas.drawRect(Rect.makeLTRB((float)(this.getScaledContentX() * scale), (float)((this.getScaledContentY() + this.getScaledContentHeight() - 2.5f) * scale), (float)((this.getScaledContentX() + this.getScaledContentWidth()) * scale), (float)((this.getScaledContentY() + this.getScaledContentHeight()) * scale)), paint);
                }
            }
            if (this.isHovered()) {
                try (Paint paint = new Paint();){
                    paint.setColor(underscoreColor.multiplied(this.getAlpha()));
                    paint.setMode(PaintMode.FILL);
                    canvas.drawRect(Rect.makeLTRB((float)(this.getScaledContentX() * scale), (float)((this.getScaledContentY() + this.getScaledContentHeight() - 1.6666666f) * scale), (float)((this.getScaledContentX() + this.getScaledContentWidth()) * scale), (float)((this.getScaledContentY() + this.getScaledContentHeight()) * scale)), paint);
                }
            }
        }
    }
}

