/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.selector;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.style.StyleNode;
import sm0keysa1m0n.bliss.style.selector.Selector;
import sm0keysa1m0n.bliss.style.selector.StyleNodeState;
import sm0keysa1m0n.bliss.style.selector.combinator.Combinator;

public class CompoundSelector
implements Selector {
    private final Deque<Element> elements = new ArrayDeque<Element>();
    private int specificity;

    public void push(Selector selector, Combinator combinator) {
        this.elements.push(new Element(selector, combinator));
        this.specificity += selector.getSpecificity();
    }

    @Override
    public Optional<Set<StyleNodeState>> match(StyleNode node) {
        HashSet<StyleNodeState> nodeStates = new HashSet<StyleNodeState>();
        Combinator combinator = Combinator.AND;
        for (Element element : this.elements) {
            if (combinator == null) {
                throw new IllegalStateException("Missing combinator for element: " + element);
            }
            Combinator.Result result = combinator.match(node, element.selector()).orElse(null);
            if (result == null) {
                return Optional.empty();
            }
            nodeStates.addAll(result.nodeStates());
            node = result.node();
            combinator = element.combinator();
        }
        return Optional.of(nodeStates);
    }

    @Override
    public int getSpecificity() {
        return this.specificity;
    }

    public String toString() {
        return "Selector[specificity=" + this.specificity + ", elements=" + this.elements.toString() + "]";
    }

    private record Element(Selector selector, @Nullable Combinator combinator) {
    }
}

