/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.parser;

import io.github.humbleui.skija.Typeface;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sm0keysa1m0n.bliss.style.StyleList;
import sm0keysa1m0n.bliss.style.StyleProperty;
import sm0keysa1m0n.bliss.style.parser.NumberedLineIterator;
import sm0keysa1m0n.bliss.style.parser.StyleSelectorParser;
import sm0keysa1m0n.bliss.style.selector.Selector;

public class StyleSheetParser {
    private static final Logger logger = LoggerFactory.getLogger(StyleSheetParser.class);
    private static final String IMPORT = "@import";
    private static final String FONT_FACE = "@font-face";

    private StyleSheetParser() {
    }

    public static ParseResult loadStyleSheet(InputStream inputStream, FontLoader fontLoader) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            ParseResult parseResult = StyleSheetParser.loadStyleSheet(reader, fontLoader);
            return parseResult;
        }
    }

    public static ParseResult loadStyleSheet(Reader reader, FontLoader fontLoader) throws IOException {
        StyleList list = new StyleList();
        ArrayList<String> dependencies = new ArrayList<String>();
        NumberedLineIterator iterator = new NumberedLineIterator(reader);
        boolean insideComment = false;
        while (iterator.hasNext()) {
            String line = iterator.nextLine().trim();
            if (StringUtils.isEmpty((CharSequence)line)) continue;
            if (line.startsWith("/*")) {
                insideComment = !line.endsWith("*/");
                continue;
            }
            if (insideComment && line.startsWith("*/")) {
                insideComment = false;
                continue;
            }
            if (line.startsWith("@")) {
                if (line.startsWith(FONT_FACE)) {
                    StyleSheetParser.readFontFace(iterator, list, fontLoader);
                    continue;
                }
                if (line.startsWith(IMPORT)) {
                    dependencies.add(line.substring(IMPORT.length()).replace("'", "").replace("\"", "").replace(";", "").trim());
                    continue;
                }
                logger.warn("Unknown at-rule: {}", (Object)line);
                continue;
            }
            Selector[] selectors = StyleSelectorParser.readSelectors(line, iterator);
            Set<StyleProperty> properties = StyleSheetParser.readBlock(iterator);
            for (Selector selector : selectors) {
                list.addRule(selector, properties);
            }
        }
        return new ParseResult(list, dependencies);
    }

    private static void readFontFace(NumberedLineIterator content, StyleList styleList, FontLoader fontLoader) throws IOException {
        int startLineNumber = content.getLineNumber();
        String currentLine = content.nextLine().trim();
        String fontFamily = null;
        String location = null;
        while (!StringUtils.contains((CharSequence)currentLine, (CharSequence)"}")) {
            if (currentLine.startsWith("font-family")) {
                int quote = currentLine.contains("\"") ? 34 : 39;
                fontFamily = currentLine.substring(currentLine.indexOf(quote) + 1, currentLine.lastIndexOf(quote));
                currentLine = content.nextLine().trim();
                continue;
            }
            if (currentLine.startsWith("src")) {
                location = currentLine.substring(currentLine.indexOf(58) + 1).replace("'", "").replace("\"", "").replace(";", "").trim();
            }
            currentLine = content.nextLine().trim();
        }
        if (fontFamily == null) {
            logger.error("No font-family property specified for font-face at line: {}", (Object)startLineNumber);
            return;
        }
        if (location == null) {
            logger.error("No src property specified for font-face at line: {}", (Object)startLineNumber);
            return;
        }
        styleList.addFont(fontFamily, fontLoader.load(location));
    }

    private static Set<StyleProperty> readBlock(NumberedLineIterator content) {
        if (!content.hasNext()) {
            return Set.of();
        }
        String currentLine = content.nextLine().strip();
        LinkedHashSet<StyleProperty> elements = new LinkedHashSet<StyleProperty>();
        while (!StringUtils.contains((CharSequence)currentLine, (CharSequence)"}")) {
            if (StringUtils.contains((CharSequence)currentLine, (CharSequence)"{")) {
                logger.error("Found opening bracket at line " + content.getLineNumber() + " while inside a block");
                return Set.of();
            }
            if (currentLine.isBlank()) {
                currentLine = content.nextLine().strip();
                continue;
            }
            StringBuilder propertyBuilder = new StringBuilder(currentLine);
            while (!currentLine.endsWith(";")) {
                currentLine = content.nextLine().strip();
                propertyBuilder.append(currentLine);
            }
            String[] propertyParts = propertyBuilder.toString().replace(';', ' ').strip().split(":", 2);
            StyleProperty property = new StyleProperty(propertyParts[0].strip(), propertyParts[1].strip());
            elements.remove(property);
            elements.add(property);
            if (!content.hasNext()) {
                return Set.of();
            }
            currentLine = content.nextLine().strip();
        }
        return elements;
    }

    @FunctionalInterface
    public static interface FontLoader {
        public Typeface load(String var1) throws IOException;
    }

    public record ParseResult(StyleList styleList, Collection<String> dependencies) {
    }
}

