/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.calc;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import sm0keysa1m0n.bliss.Length;
import sm0keysa1m0n.bliss.calc.CalcExpressionNode;

public class CalcParser {
    public static CalcExpressionNode parse(String expression) {
        expression.replace("calc", "");
        List<String> terms = CalcParser.infixToRpn(expression);
        ArrayDeque<Record> stack = new ArrayDeque<Record>();
        for (String term : terms) {
            CalcExpressionNode b;
            CalcExpressionNode a;
            if (term.equals("+")) {
                stack.push(new CalcExpressionNode.OperationNode(CalcExpressionNode.Operator.ADD, (CalcExpressionNode)stack.pop(), (CalcExpressionNode)stack.pop()));
                continue;
            }
            if (term.equals("-")) {
                a = (CalcExpressionNode)stack.pop();
                b = (CalcExpressionNode)stack.pop();
                stack.push(new CalcExpressionNode.OperationNode(CalcExpressionNode.Operator.SUBTRACT, b, a));
                continue;
            }
            if (term.equals("*")) {
                stack.push(new CalcExpressionNode.OperationNode(CalcExpressionNode.Operator.MULTIPLY, (CalcExpressionNode)stack.pop(), (CalcExpressionNode)stack.pop()));
                continue;
            }
            if (term.equals("/")) {
                a = (CalcExpressionNode)stack.pop();
                b = (CalcExpressionNode)stack.pop();
                stack.push(new CalcExpressionNode.OperationNode(CalcExpressionNode.Operator.DIVIDE, b, a));
                continue;
            }
            if (term.endsWith("px")) {
                stack.push(new CalcExpressionNode.LengthNode(Length.fixed(Float.parseFloat(term.substring(0, term.length() - 2)))));
                continue;
            }
            if (term.endsWith("%")) {
                stack.push(new CalcExpressionNode.LengthNode(Length.percentage(Float.parseFloat(term.substring(0, term.length() - 1)))));
                continue;
            }
            stack.push(new CalcExpressionNode.NumberNode(Float.parseFloat(term)));
        }
        return (CalcExpressionNode)stack.pop();
    }

    private static boolean isValue(char c) {
        return Character.isLetterOrDigit(c) || c == '%' || c == '.';
    }

    private static int getPrecedence(char ch) {
        return switch (ch) {
            case '+', '-' -> 1;
            case '*', '/' -> 2;
            case '^' -> 3;
            default -> -1;
        };
    }

    private static boolean hasLeftAssociativity(char ch) {
        return ch == '+' || ch == '-' || ch == '/' || ch == '*';
    }

    private static List<String> infixToRpn(String expression) {
        ArrayDeque<Character> stack = new ArrayDeque<Character>();
        ArrayList<String> output = new ArrayList<String>();
        StringBuilder tokenBuilder = new StringBuilder();
        for (int i = 0; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (CalcParser.isValue(ch)) {
                tokenBuilder.append(ch);
                continue;
            }
            if (ch == '(') {
                stack.push(Character.valueOf(ch));
                continue;
            }
            if (ch == ')') {
                if (!tokenBuilder.isEmpty()) {
                    output.add(tokenBuilder.toString());
                    tokenBuilder = new StringBuilder();
                }
                while (!stack.isEmpty() && ((Character)stack.peek()).charValue() != '(') {
                    output.add(((Character)stack.pop()).toString());
                }
                stack.pop();
                continue;
            }
            if (!tokenBuilder.isEmpty()) {
                output.add(tokenBuilder.toString());
                tokenBuilder = new StringBuilder();
            }
            while (!stack.isEmpty() && CalcParser.getPrecedence(ch) <= CalcParser.getPrecedence(((Character)stack.peek()).charValue()) && CalcParser.hasLeftAssociativity(ch)) {
                output.add(((Character)stack.pop()).toString());
            }
            stack.push(Character.valueOf(ch));
        }
        if (!tokenBuilder.isEmpty()) {
            output.add(tokenBuilder.toString());
        }
        while (!stack.isEmpty()) {
            if (((Character)stack.peek()).charValue() == '(') {
                throw new IllegalStateException("Invalid expression: " + expression);
            }
            output.add(((Character)stack.pop()).toString());
        }
        return output;
    }
}

