/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.calc;

import com.google.common.base.Preconditions;
import sm0keysa1m0n.bliss.Length;

public interface CalcExpressionNode {
    public float evaluate(float var1);

    public Type type();

    public static enum Type {
        NUMBER,
        LENGTH,
        OPERATION,
        NEGATION,
        INVERSION;

    }

    public static enum Operator {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE;

    }

    public record OperationNode(Operator operator, CalcExpressionNode[] children) implements CalcExpressionNode
    {
        @Override
        public float evaluate(float maxValue) {
            return switch (this.operator) {
                default -> throw new IncompatibleClassChangeError();
                case Operator.ADD -> {
                    float sum = 0.0f;
                    for (CalcExpressionNode child : this.children) {
                        sum += child.evaluate(maxValue);
                    }
                    yield sum;
                }
                case Operator.SUBTRACT -> {
                    Preconditions.checkState((this.children.length == 2 ? 1 : 0) != 0);
                    float left = this.children[0].evaluate(maxValue);
                    float right = this.children[1].evaluate(maxValue);
                    yield left - right;
                }
                case Operator.MULTIPLY -> {
                    float product = 1.0f;
                    for (CalcExpressionNode child : this.children) {
                        product *= child.evaluate(maxValue);
                    }
                    yield product;
                }
                case Operator.DIVIDE -> {
                    Preconditions.checkState((this.children.length == 2 ? 1 : 0) != 0);
                    float left = this.children[0].evaluate(maxValue);
                    float right = this.children[1].evaluate(maxValue);
                    yield left / right;
                }
            };
        }

        @Override
        public Type type() {
            return Type.OPERATION;
        }
    }

    public record NegationNode(CalcExpressionNode child) implements CalcExpressionNode
    {
        @Override
        public float evaluate(float maxValue) {
            return -this.child.evaluate(maxValue);
        }

        @Override
        public Type type() {
            return Type.NEGATION;
        }
    }

    public record InversionNode(CalcExpressionNode child) implements CalcExpressionNode
    {
        @Override
        public float evaluate(float maxValue) {
            return 1.0f / this.child.evaluate(maxValue);
        }

        @Override
        public Type type() {
            return Type.INVERSION;
        }
    }

    public record LengthNode(Length length) implements CalcExpressionNode
    {
        @Override
        public float evaluate(float maxValue) {
            return this.length.valueForLength(maxValue);
        }

        @Override
        public Type type() {
            return Type.LENGTH;
        }
    }

    public record NumberNode(float value) implements CalcExpressionNode
    {
        @Override
        public float evaluate(float maxValue) {
            return this.value;
        }

        @Override
        public Type type() {
            return Type.NUMBER;
        }
    }
}

